/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.handlers;

import com.darkona.adventurebackpack.common.ServerActions;
import com.darkona.adventurebackpack.init.ModNetwork;
import com.darkona.adventurebackpack.inventory.SlotTool;
import com.darkona.adventurebackpack.item.ItemAdventureBackpack;
import com.darkona.adventurebackpack.item.ItemHose;
import com.darkona.adventurebackpack.network.CycleToolPacket;
import com.darkona.adventurebackpack.reference.BackpackNames;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.FluidTank;

public class ClientEventHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void toolTips(ItemTooltipEvent event) {
        if (event.itemStack.func_77973_b() instanceof ItemAdventureBackpack) {
            NBTTagCompound compound = event.itemStack.field_77990_d;
            FluidTank tank = new FluidTank(4000);
            String tankInfo = "";
            if (compound != null) {
                String name;
                if (compound.func_74764_b("leftTank")) {
                    tank.readFromNBT(compound.func_74775_l("leftTank"));
                    name = tank.getFluid() == null ? "" : tank.getFluid().getLocalizedName();
                    tankInfo = EnumChatFormatting.BLUE + "Left Tank: " + tank.getFluidAmount() + "/" + tank.getCapacity() + " " + name;
                    event.toolTip.add(tankInfo);
                }
                if (compound.func_74764_b("rightTank")) {
                    tank.readFromNBT(compound.func_74775_l("rightTank"));
                    name = tank.getFluid() == null ? "" : tank.getFluid().getLocalizedName();
                    tankInfo = EnumChatFormatting.RED + "Right Tank: " + tank.getFluidAmount() + "/" + tank.getCapacity() + " " + name;
                    event.toolTip.add(tankInfo);
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void mouseWheelDetect(MouseEvent event) {
        ItemStack backpack;
        EntityClientPlayerMP player;
        Minecraft mc = Minecraft.func_71410_x();
        int dWheel = event.dwheel;
        if (dWheel != 0 && (player = mc.field_71439_g) != null && !player.field_70128_L && player.func_70093_af() && (backpack = Wearing.getWearingBackpack((EntityPlayer)player)) != null && backpack.func_77973_b() instanceof ItemAdventureBackpack && player.func_71045_bC() != null) {
            int slot = player.field_71071_by.field_70461_c;
            ItemStack heldItem = player.field_71071_by.func_70301_a(slot);
            Item theItem = heldItem.func_77973_b();
            if (SlotTool.isValidTool(heldItem) || BackpackNames.getBackpackColorName(backpack).equals("Skeleton") && theItem.equals(Items.field_151031_f)) {
                ModNetwork.net.sendToServer((IMessage)new CycleToolPacket.CycleToolMessage(dWheel, slot, 2));
                ServerActions.cycleTool((EntityPlayer)player, dWheel, slot);
                event.setCanceled(true);
            }
            if (theItem instanceof ItemHose) {
                ModNetwork.net.sendToServer((IMessage)new CycleToolPacket.CycleToolMessage(dWheel, slot, 1));
                ServerActions.switchHose((EntityPlayer)player, false, dWheel, slot);
                event.setCanceled(true);
            }
        }
    }
}

