/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.network;

import com.darkona.adventurebackpack.common.ServerActions;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class WearableModePacket
implements IMessageHandler<Message, Message> {
    public static byte COPTER_ON_OFF = 0;
    public static byte COPTER_TOGGLE = 1;
    public static byte JETPACK_ON_OFF = (byte)2;

    public Message onMessage(Message message, MessageContext ctx) {
        EntityPlayerMP player;
        if (ctx.side.isServer() && (player = ctx.getServerHandler().field_147369_b) != null) {
            if (message.type == COPTER_ON_OFF || message.type == COPTER_TOGGLE) {
                ServerActions.toggleCopterPack((EntityPlayer)player, Wearing.getWearingCopter((EntityPlayer)player), message.type);
            }
            if (message.type == JETPACK_ON_OFF) {
                ServerActions.toggleSteamJetpack((EntityPlayer)player, Wearing.getWearingSteam((EntityPlayer)player), message.type);
            }
        }
        if (ctx.side.isClient()) {
            // empty if block
        }
        return null;
    }

    public static class Message
    implements IMessage {
        private byte type;
        private String playerID;

        public Message() {
        }

        public Message(byte type, String playerID) {
            this.type = type;
            this.playerID = playerID;
        }

        public void fromBytes(ByteBuf buf) {
            this.type = buf.readByte();
            this.playerID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte((int)this.type);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerID);
        }
    }
}

