/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.playerProperties;

import com.darkona.adventurebackpack.init.ModNetwork;
import com.darkona.adventurebackpack.item.IBackWearableItem;
import com.darkona.adventurebackpack.network.SyncPropertiesPacket;
import com.darkona.adventurebackpack.util.Utils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class BackpackProperty
implements IExtendedEntityProperties {
    public static final String PROPERTY_NAME = "abp.property";
    protected EntityPlayer player = null;
    private ItemStack wearable = null;
    private ChunkCoordinates campFire = null;
    private NBTTagCompound wearableData = new NBTTagCompound();
    private boolean forceCampFire = false;
    private int dimension = 0;

    public NBTTagCompound getWearableData() {
        return this.wearableData;
    }

    public static void sync(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            BackpackProperty.syncToNear(player);
        }
    }

    public static void syncToNear(EntityPlayer player) {
        if (player != null && player instanceof EntityPlayerMP) {
            try {
                ((EntityPlayerMP)player).func_71121_q().func_73039_n().func_151248_b((Entity)player, ModNetwork.net.getPacketFrom((IMessage)new SyncPropertiesPacket.Message(player.func_145782_y(), BackpackProperty.get(player).getData())));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public BackpackProperty(EntityPlayer player) {
        this.player = player;
    }

    public NBTTagCompound getData() {
        NBTTagCompound data = new NBTTagCompound();
        this.saveNBTData(data);
        return data;
    }

    public static void register(EntityPlayer player) {
        player.registerExtendedProperties(PROPERTY_NAME, (IExtendedEntityProperties)new BackpackProperty(player));
    }

    public static BackpackProperty get(EntityPlayer player) {
        return (BackpackProperty)player.getExtendedProperties(PROPERTY_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        if (this.wearable != null) {
            compound.func_74782_a("wearable", (NBTBase)this.wearable.func_77955_b(new NBTTagCompound()));
        }
        if (this.campFire != null) {
            compound.func_74768_a("campFireX", this.campFire.field_71574_a);
            compound.func_74768_a("campFireY", this.campFire.field_71572_b);
            compound.func_74768_a("campFireZ", this.campFire.field_71573_c);
            compound.func_74768_a("campFireDim", this.dimension);
        }
        compound.func_74757_a("forceCampFire", this.forceCampFire);
    }

    public void loadNBTData(NBTTagCompound compound) {
        if (compound != null) {
            this.setWearable(compound.func_74764_b("wearable") ? ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("wearable")) : null);
            this.setCampFire(new ChunkCoordinates(compound.func_74762_e("campFireX"), compound.func_74762_e("campFireY"), compound.func_74762_e("campFireZ")));
            this.dimension = compound.func_74762_e("compFireDim");
            this.forceCampFire = compound.func_74767_n("forceCampfire");
        }
    }

    public void init(Entity entity, World world) {
        this.player = (EntityPlayer)entity;
    }

    public void setWearable(ItemStack bp) {
        this.wearable = bp;
    }

    public ItemStack getWearable() {
        return this.wearable != null ? this.wearable : null;
    }

    public void setCampFire(ChunkCoordinates cf) {
        this.campFire = cf;
    }

    public boolean hasWearable() {
        return this.wearable != null;
    }

    public ChunkCoordinates getCampFire() {
        return this.campFire;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean isForcedCampFire() {
        return this.forceCampFire;
    }

    public void setForceCampFire(boolean forceCampFire) {
        this.forceCampFire = forceCampFire;
    }

    public void executeWearableUpdateProtocol() {
        if (Utils.notNullAndInstanceOf(this.wearable.func_77973_b(), IBackWearableItem.class)) {
            ((IBackWearableItem)this.wearable.func_77973_b()).onEquippedUpdate(this.player.func_130014_f_(), this.player, this.wearable);
        }
    }

    public void executeWearableDeathProtocol() {
        if (Utils.notNullAndInstanceOf(this.wearable.func_77973_b(), IBackWearableItem.class)) {
            ((IBackWearableItem)this.wearable.func_77973_b()).onPlayerDeath(this.player.func_130014_f_(), this.player, this.wearable);
        }
    }

    public void executeWearableEquipProtocol() {
        if (Utils.notNullAndInstanceOf(this.wearable.func_77973_b(), IBackWearableItem.class)) {
            ((IBackWearableItem)this.wearable.func_77973_b()).onEquipped(this.player.func_130014_f_(), this.player, this.wearable);
        }
    }

    public void executeWearableUnequipProtocol() {
        if (Utils.notNullAndInstanceOf(this.wearable.func_77973_b(), IBackWearableItem.class)) {
            ((IBackWearableItem)this.wearable.func_77973_b()).onUnequipped(this.player.func_130014_f_(), this.player, this.wearable);
        }
    }
}

