/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.client;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.therandomlabs.randomtweaks.RandomTweaks;
import com.therandomlabs.randomtweaks.config.RTConfig;
import com.therandomlabs.randomtweaks.repackage.com.therandomlabs.randomlib.TRLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="randomtweaks")
public final class CapeHandler {
    public static final ResourceLocation CAPE_LOCATION = new ResourceLocation("randomtweaks", "textures/cape.png");
    public static final String CONTRIBUTORS_URL = "https://raw.githubusercontent.com/TheRandomLabs/RandomTweaks/misc/contributors.txt";
    private static List<String> contributors = Collections.emptyList();

    @SubscribeEvent
    public static void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
        if (!RTConfig.Client.contributorCapes) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntityPlayer();
        if (!CapeHandler.hasCape((EntityPlayer)player)) {
            return;
        }
        NetworkPlayerInfo info = player.func_175155_b();
        if (info == null) {
            info = new NetworkPlayerInfo(player.func_146103_bH());
            info.field_78829_b = Integer.MIN_VALUE;
            player.field_175157_a = info;
        }
        if (info.field_187107_a.get(MinecraftProfileTexture.Type.CAPE) == null) {
            info.field_187107_a.put(MinecraftProfileTexture.Type.CAPE, CAPE_LOCATION);
            info.field_187107_a.put(MinecraftProfileTexture.Type.ELYTRA, CAPE_LOCATION);
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        if (!RTConfig.Client.contributorCapes) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntityPlayer();
        if (CapeHandler.hasCape((EntityPlayer)player) && player.field_175157_a != null && player.field_175157_a.field_78829_b == Integer.MIN_VALUE) {
            player.field_175157_a = null;
        }
    }

    public static void downloadPlayers() {
        new Thread(() -> {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(CONTRIBUTORS_URL).openConnection();
                connection.setConnectTimeout(1000);
                contributors = IOUtils.readLines((InputStream)connection.getInputStream(), (Charset)StandardCharsets.UTF_8);
                connection.disconnect();
            }
            catch (IOException ex) {
                RandomTweaks.LOGGER.error("Failed to download conbtributor list", (Throwable)ex);
            }
        }).start();
    }

    public static boolean hasCape(EntityPlayer player) {
        return TRLUtils.IS_DEOBFUSCATED || contributors.contains(player.func_110124_au().toString());
    }
}

