/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common;

import com.therandomlabs.randomtweaks.config.RTConfig;
import net.minecraft.util.FoodStats;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.hunger.ExhaustionEvent;

public class RTFoodStats
extends FoodStats {
    public RTFoodStats(FoodStats stats) {
        this.field_75127_a = stats.field_75127_a;
        this.field_75126_c = stats.field_75126_c;
        this.field_75125_b = stats.field_75125_b;
        this.field_75123_d = stats.field_75123_d;
    }

    public void func_75122_a(int foodLevel, float foodSaturationModifier) {
        Tuple<Integer, Float> stats = RTFoodStats.addStats(this.field_75127_a, this.field_75125_b, foodLevel, foodSaturationModifier);
        this.field_75127_a = (Integer)stats.func_76341_a();
        this.field_75125_b = ((Float)stats.func_76340_b()).floatValue();
    }

    public void func_75113_a(float exhaustion) {
        super.func_75113_a(exhaustion * (float)RTConfig.Hunger.exhaustionMultiplier);
    }

    public static Tuple<Integer, Float> addStats(int originalFoodLevel, float originalSaturation, int foodLevel, float foodSaturationModifier) {
        float maxSaturationLevel;
        int newFoodLevel = originalFoodLevel + foodLevel;
        float newSaturation = originalSaturation + (float)foodLevel * foodSaturationModifier * 2.0f;
        if (newFoodLevel > RTConfig.Hunger.maximumHungerLevel) {
            if (RTConfig.Hunger.carryExcessHungerToSaturation) {
                newSaturation += (float)(originalFoodLevel - RTConfig.Hunger.maximumHungerLevel);
            }
            newFoodLevel = RTConfig.Hunger.maximumHungerLevel;
        }
        if ((maxSaturationLevel = (float)newFoodLevel + (float)RTConfig.Hunger.saturationLimit) == Float.NEGATIVE_INFINITY) {
            maxSaturationLevel = Float.MAX_VALUE;
        }
        newSaturation = Math.min(newSaturation, maxSaturationLevel);
        return new Tuple((Object)newFoodLevel, (Object)Float.valueOf(newSaturation));
    }

    public static class AppleCoreEventHandler {
        @SubscribeEvent
        public static void onFoodStatsAddition(FoodEvent.FoodStatsAddition event) {
            event.setCanceled(true);
            FoodStats stats = event.player.func_71024_bL();
            Tuple<Integer, Float> newStats = RTFoodStats.addStats(stats.field_75127_a, stats.field_75125_b, event.foodValuesToBeAdded.hunger, event.foodValuesToBeAdded.saturationModifier);
            stats.field_75127_a = (Integer)newStats.func_76341_a();
            stats.field_75125_b = ((Float)newStats.func_76340_b()).floatValue();
        }

        @SubscribeEvent
        public static void onExhaustionAddition(ExhaustionEvent.ExhaustionAddition event) {
            event.deltaExhaustion = (float)((double)event.deltaExhaustion * RTConfig.Hunger.exhaustionMultiplier);
        }
    }
}

