/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common.world;

import com.therandomlabs.randomtweaks.RandomTweaks;
import com.therandomlabs.randomtweaks.common.world.WorldTypeVoid;
import com.therandomlabs.randomtweaks.common.world.WorldTypeVoidIslands;
import com.therandomlabs.randomtweaks.config.RTConfig;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomtweaks")
public final class WorldHandler {
    private static final Random random = new Random();

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        if (!RTConfig.World.fixDuplicateEntityUUIDs) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Chunk chunk = event.getChunk();
        WorldServer serverWorld = (WorldServer)world;
        for (ClassInheritanceMultiMap entities : chunk.func_177429_s()) {
            for (Entity entity : entities) {
                UUID newUUID;
                UUID uuid;
                Entity entityFromUUID;
                if (entity instanceof EntityPlayer || (entityFromUUID = serverWorld.func_175733_a(uuid = entity.func_110124_au())) == null || entityFromUUID == entity) continue;
                while (serverWorld.func_175733_a(newUUID = MathHelper.func_180182_a((Random)random)) != null) {
                }
                if (RTConfig.World.logEntityUUIDReassignments) {
                    RandomTweaks.LOGGER.info("Changing UUID of entity {} from {} to {}", (Object)EntityList.func_191301_a((Entity)entity), (Object)uuid, (Object)newUUID);
                }
                entity.func_184221_a(newUUID);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        String[] damageMultipliers;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        GameRules gameRules = world.func_82736_K();
        String netherPortalCreation = RTConfig.GameRules.disableNetherPortalCreation;
        if (!netherPortalCreation.isEmpty() && !gameRules.func_82765_e(netherPortalCreation)) {
            gameRules.func_82764_b(netherPortalCreation, "false");
        }
        for (String gameRule : damageMultipliers = new String[]{RTConfig.GameRules.drowningDamageMultiplier, RTConfig.GameRules.fallDamageMultiplier, RTConfig.GameRules.fireDamageMultiplier}) {
            if (gameRule.isEmpty() || gameRules.func_82765_e(gameRule)) continue;
            gameRules.func_82764_b(gameRule, "1.0");
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.Clone event) {
        WorldHandler.onPlayerSpawn(event.getEntityPlayer());
    }

    @SubscribeEvent
    public static void onPlayerLoad(PlayerEvent.LoadFromFile event) {
        WorldHandler.onPlayerSpawn(event.getEntityPlayer());
    }

    private static void onPlayerSpawn(EntityPlayer player) {
        World world = player.func_130014_f_();
        if (world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
            return;
        }
        WorldType type = world.func_175624_G();
        if (type instanceof WorldTypeVoid) {
            WorldHandler.onPlayerSpawnInVoidWorld(player, false);
        } else if (type instanceof WorldTypeVoidIslands) {
            WorldHandler.onPlayerSpawnInVoidWorld(player, true);
        }
    }

    private static void onPlayerSpawnInVoidWorld(EntityPlayer player, boolean voidIslands) {
        int newSpawnY;
        if (player.field_71075_bZ.field_75100_b) {
            return;
        }
        World world = player.func_130014_f_();
        if (WorldHandler.isSpawnable(world, world.func_175672_r(player.func_180425_c()))) {
            return;
        }
        BlockPos playerSpawnPoint = player.func_180470_cg();
        boolean usingWorldSpawn = false;
        if (playerSpawnPoint == null) {
            playerSpawnPoint = world.func_175694_M();
            usingWorldSpawn = true;
        }
        if (WorldHandler.isSpawnable(world, world.func_175672_r(playerSpawnPoint))) {
            return;
        }
        if (voidIslands) {
            BlockPos pos = world.func_175672_r(new BlockPos(0, 0, 0));
            newSpawnY = pos.func_177956_o() + 1;
        } else {
            newSpawnY = RTConfig.VoidWorld.ySpawn;
        }
        BlockPos newSpawn = new BlockPos(0, newSpawnY, 0);
        player.func_70107_b(0.5, (double)newSpawnY, 0.5);
        player.func_180473_a(newSpawn, true);
        if (usingWorldSpawn) {
            world.func_175652_B(newSpawn);
        }
        if (voidIslands) {
            return;
        }
        BlockPos spawnBlock = new BlockPos(0, newSpawnY - 1, 0);
        if (WorldHandler.isSpawnable(world, spawnBlock)) {
            return;
        }
        world.func_175656_a(spawnBlock, RTConfig.VoidWorld.spawnBlockState);
    }

    private static boolean isSpawnable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockBed) {
            return BlockBed.func_176468_a((World)world, (BlockPos)pos, (int)0) != null;
        }
        return state.func_185904_a().func_76230_c();
    }
}

