/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.advancement.criterion;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;

public class GenericTrigger
implements ICriterionTrigger {
    private final ResourceLocation id;
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public GenericTrigger(String id) {
        this.id = new ResourceLocation("galacticraftcore", id);
    }

    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener listener) {
        Listeners listeners = this.listeners.get(playerAdvancements);
        if (listeners == null) {
            listeners = new Listeners(playerAdvancements);
            this.listeners.put(playerAdvancements, listeners);
        }
        listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements advancements, ICriterionTrigger.Listener listener) {
        Listeners listeners = this.listeners.get(advancements);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(advancements);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements advancements) {
        this.listeners.remove(advancements);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        return new Instance(this.func_192163_a());
    }

    public void trigger(EntityPlayerMP playerMP) {
        Listeners listeners = this.listeners.get(playerMP.func_192039_O());
        if (listeners != null) {
            listeners.trigger(playerMP);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements advancements) {
            this.playerAdvancements = advancements;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener listener) {
            this.listeners.remove(listener);
        }

        public void trigger(EntityPlayerMP player) {
            ArrayList list = null;
            for (ICriterionTrigger.Listener listener : this.listeners) {
                if (!(listener.func_192158_a() instanceof Instance) || !((Instance)listener.func_192158_a()).test(player)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        public Instance(ResourceLocation resourceLocation) {
            super(resourceLocation);
        }

        public boolean test(EntityPlayerMP player) {
            return true;
        }
    }
}

