/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.printer;

import com.github.lunatrius.core.util.math.BlockPosHelper;
import com.github.lunatrius.core.util.math.MBlockPos;
import com.github.lunatrius.schematica.block.state.BlockStateHelper;
import com.github.lunatrius.schematica.client.printer.nbtsync.NBTSync;
import com.github.lunatrius.schematica.client.printer.nbtsync.SyncRegistry;
import com.github.lunatrius.schematica.client.printer.registry.PlacementData;
import com.github.lunatrius.schematica.client.printer.registry.PlacementRegistry;
import com.github.lunatrius.schematica.client.util.BlockStateToItemStack;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import com.github.lunatrius.schematica.reference.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketEntityAction;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;

public class SchematicPrinter {
    public static final SchematicPrinter INSTANCE = new SchematicPrinter();
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private boolean isEnabled = true;
    private boolean isPrinting = false;
    private SchematicWorld schematic = null;
    private byte[][][] timeout = null;
    private HashMap<BlockPos, Integer> syncBlacklist = new HashMap();

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean togglePrinting() {
        this.isPrinting = !this.isPrinting && this.schematic != null;
        return this.isPrinting;
    }

    public boolean isPrinting() {
        return this.isPrinting;
    }

    public void setPrinting(boolean isPrinting) {
        this.isPrinting = isPrinting;
    }

    public SchematicWorld getSchematic() {
        return this.schematic;
    }

    public void setSchematic(SchematicWorld schematic) {
        this.isPrinting = false;
        this.schematic = schematic;
        this.refresh();
    }

    public void refresh() {
        this.timeout = this.schematic != null ? new byte[this.schematic.getWidth()][this.schematic.func_72800_K()][this.schematic.getLength()] : (byte[][][])null;
        this.syncBlacklist.clear();
    }

    public boolean print(WorldClient world, EntityPlayerSP player) {
        double dX = ClientProxy.playerPosition.x - (double)this.schematic.position.field_177962_a;
        double dY = ClientProxy.playerPosition.y - (double)this.schematic.position.field_177960_b;
        double dZ = ClientProxy.playerPosition.z - (double)this.schematic.position.field_177961_c;
        int x = (int)Math.floor(dX);
        int y = (int)Math.floor(dY);
        int z = (int)Math.floor(dZ);
        int range = ConfigurationHandler.placeDistance;
        int minX = Math.max(0, x - range);
        int maxX = Math.min(this.schematic.getWidth() - 1, x + range);
        int minY = Math.max(0, y - range);
        int maxY = Math.min(this.schematic.func_72800_K() - 1, y + range);
        int minZ = Math.max(0, z - range);
        int maxZ = Math.min(this.schematic.getLength() - 1, z + range);
        if (minX > maxX || minY > maxY || minZ > maxZ) {
            return false;
        }
        int slot = player.field_71071_by.field_70461_c;
        boolean isSneaking = player.func_70093_af();
        switch (this.schematic.layerMode) {
            case ALL: {
                break;
            }
            case SINGLE_LAYER: {
                if (this.schematic.renderingLayer > maxY) {
                    return false;
                }
                maxY = this.schematic.renderingLayer;
            }
            case ALL_BELOW: {
                if (this.schematic.renderingLayer < minY) {
                    return false;
                }
                maxY = this.schematic.renderingLayer;
            }
        }
        this.syncSneaking(player, true);
        double blockReachDistance = (double)this.minecraft.field_71442_b.func_78757_d() - 0.1;
        double blockReachDistanceSq = blockReachDistance * blockReachDistance;
        for (MBlockPos pos : BlockPosHelper.getAllInBoxXZY((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
            if (pos.func_177957_d(dX, dY, dZ) > blockReachDistanceSq) continue;
            try {
                if (!this.placeBlock(world, player, (BlockPos)pos)) continue;
                return this.syncSlotAndSneaking(player, slot, isSneaking, true);
            }
            catch (Exception e) {
                Reference.logger.error("Could not place block!", (Throwable)e);
                return this.syncSlotAndSneaking(player, slot, isSneaking, false);
            }
        }
        return this.syncSlotAndSneaking(player, slot, isSneaking, true);
    }

    private boolean syncSlotAndSneaking(EntityPlayerSP player, int slot, boolean isSneaking, boolean success) {
        player.field_71071_by.field_70461_c = slot;
        this.syncSneaking(player, isSneaking);
        return success;
    }

    private boolean placeBlock(WorldClient world, EntityPlayerSP player, BlockPos pos) {
        int z;
        int y;
        int x = pos.func_177958_n();
        if (this.timeout[x][y = pos.func_177956_o()][z = pos.func_177952_p()] > 0) {
            byte[] byArray = this.timeout[x][y];
            int n = z;
            byArray[n] = (byte)(byArray[n] - 1);
            return false;
        }
        int wx = this.schematic.position.field_177962_a + x;
        int wy = this.schematic.position.field_177960_b + y;
        int wz = this.schematic.position.field_177961_c + z;
        BlockPos realPos = new BlockPos(wx, wy, wz);
        IBlockState blockState = this.schematic.func_180495_p(pos);
        IBlockState realBlockState = world.func_180495_p(realPos);
        Block realBlock = realBlockState.func_177230_c();
        if (BlockStateHelper.areBlockStatesEqual(blockState, realBlockState)) {
            NBTSync handler = SyncRegistry.INSTANCE.getHandler(realBlock);
            if (handler != null) {
                this.timeout[x][y][z] = (byte)ConfigurationHandler.timeout;
                Integer tries = this.syncBlacklist.get(realPos);
                if (tries == null) {
                    tries = 0;
                } else if (tries >= 10) {
                    return false;
                }
                Reference.logger.trace("Trying to sync block at {} {}", (Object)realPos, (Object)tries);
                boolean success = handler.execute((EntityPlayer)player, (World)this.schematic, pos, (World)world, realPos);
                if (success) {
                    this.syncBlacklist.put(realPos, tries + 1);
                }
                return success;
            }
            return false;
        }
        if (ConfigurationHandler.destroyBlocks && !world.func_175623_d(realPos) && this.minecraft.field_71442_b.func_78758_h()) {
            this.minecraft.field_71442_b.func_180511_b(realPos, EnumFacing.DOWN);
            this.timeout[x][y][z] = (byte)ConfigurationHandler.timeout;
            return !ConfigurationHandler.destroyInstantly;
        }
        if (this.schematic.func_175623_d(pos)) {
            return false;
        }
        if (!realBlock.func_176200_f((IBlockAccess)world, realPos)) {
            return false;
        }
        ItemStack itemStack = BlockStateToItemStack.getItemStack(blockState, new RayTraceResult((Entity)player), this.schematic, pos, (EntityPlayer)player);
        if (itemStack.func_190926_b()) {
            Reference.logger.debug("{} is missing a mapping!", (Object)blockState);
            return false;
        }
        if (this.placeBlock(world, player, realPos, blockState, itemStack)) {
            this.timeout[x][y][z] = (byte)ConfigurationHandler.timeout;
            if (!ConfigurationHandler.placeInstantly) {
                return true;
            }
        }
        return false;
    }

    private boolean isSolid(World world, BlockPos pos, EnumFacing side) {
        BlockPos offset = pos.func_177972_a(side);
        IBlockState blockState = world.func_180495_p(offset);
        Block block = blockState.func_177230_c();
        if (block == null) {
            return false;
        }
        if (block.isAir(blockState, (IBlockAccess)world, offset)) {
            return false;
        }
        if (block instanceof BlockFluidBase) {
            return false;
        }
        return !block.func_176200_f((IBlockAccess)world, offset);
    }

    private List<EnumFacing> getSolidSides(World world, BlockPos pos) {
        if (!ConfigurationHandler.placeAdjacent) {
            return Arrays.asList(EnumFacing.field_82609_l);
        }
        ArrayList<EnumFacing> list = new ArrayList<EnumFacing>();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (!this.isSolid(world, pos, side)) continue;
            list.add(side);
        }
        return list;
    }

    private boolean placeBlock(WorldClient world, EntityPlayerSP player, BlockPos pos, IBlockState blockState, ItemStack itemStack) {
        int extraClicks;
        float offsetZ;
        float offsetY;
        float offsetX;
        EnumFacing direction;
        if (itemStack.func_77973_b() instanceof ItemBucket) {
            return false;
        }
        PlacementData data = PlacementRegistry.INSTANCE.getPlacementData(blockState, itemStack);
        if (data != null && !data.isValidPlayerFacing(blockState, (EntityPlayer)player, pos, (World)world)) {
            return false;
        }
        List<EnumFacing> solidSides = this.getSolidSides((World)world, pos);
        if (solidSides.size() == 0) {
            return false;
        }
        if (data != null) {
            List<EnumFacing> validDirections = data.getValidBlockFacings(solidSides, blockState);
            if (validDirections.size() == 0) {
                return false;
            }
            direction = validDirections.get(0);
            offsetX = data.getOffsetX(blockState);
            offsetY = data.getOffsetY(blockState);
            offsetZ = data.getOffsetZ(blockState);
            extraClicks = data.getExtraClicks(blockState);
        } else {
            direction = solidSides.get(0);
            offsetX = 0.5f;
            offsetY = 0.5f;
            offsetZ = 0.5f;
            extraClicks = 0;
        }
        if (!this.swapToItem(player.field_71071_by, itemStack)) {
            return false;
        }
        return this.placeBlock(world, player, pos, direction, offsetX, offsetY, offsetZ, extraClicks);
    }

    private boolean placeBlock(WorldClient world, EntityPlayerSP player, BlockPos pos, EnumFacing direction, float offsetX, float offsetY, float offsetZ, int extraClicks) {
        EnumHand hand = EnumHand.MAIN_HAND;
        ItemStack itemStack = player.func_184586_b(hand);
        boolean success = false;
        if (!this.minecraft.field_71442_b.func_78758_h() && !itemStack.func_190926_b() && itemStack.func_190916_E() <= extraClicks) {
            return false;
        }
        BlockPos offset = pos.func_177972_a(direction);
        EnumFacing side = direction.func_176734_d();
        Vec3d hitVec = new Vec3d((double)((float)offset.func_177958_n() + offsetX), (double)((float)offset.func_177956_o() + offsetY), (double)((float)offset.func_177952_p() + offsetZ));
        success = this.placeBlock(world, player, itemStack, offset, side, hitVec, hand);
        for (int i = 0; success && i < extraClicks; ++i) {
            success = this.placeBlock(world, player, itemStack, offset, side, hitVec, hand);
        }
        if (itemStack.func_190916_E() == 0 && success) {
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
        }
        return success;
    }

    private boolean placeBlock(WorldClient world, EntityPlayerSP player, ItemStack itemStack, BlockPos pos, EnumFacing side, Vec3d hitVec, EnumHand hand) {
        BlockPos actualPos = ConfigurationHandler.placeAdjacent ? pos : pos.func_177972_a(side);
        EnumActionResult result = this.minecraft.field_71442_b.func_187099_a(player, world, actualPos, side, hitVec, hand);
        if (result != EnumActionResult.SUCCESS) {
            return false;
        }
        player.func_184609_a(hand);
        return true;
    }

    private void syncSneaking(EntityPlayerSP player, boolean isSneaking) {
        player.func_70095_a(isSneaking);
        player.field_71174_a.func_147297_a((Packet)new CPacketEntityAction((Entity)player, isSneaking ? CPacketEntityAction.Action.START_SNEAKING : CPacketEntityAction.Action.STOP_SNEAKING));
    }

    private boolean swapToItem(InventoryPlayer inventory, ItemStack itemStack) {
        return this.swapToItem(inventory, itemStack, true);
    }

    private boolean swapToItem(InventoryPlayer inventory, ItemStack itemStack, boolean swapSlots) {
        int slot = this.getInventorySlotWithItem(inventory, itemStack);
        if (this.minecraft.field_71442_b.func_78758_h() && (slot < 0 || slot >= 9) && ConfigurationHandler.swapSlotsQueue.size() > 0) {
            inventory.field_70461_c = this.getNextSlot();
            inventory.func_70299_a(inventory.field_70461_c, itemStack.func_77946_l());
            this.minecraft.field_71442_b.func_78761_a(inventory.func_70301_a(inventory.field_70461_c), 36 + inventory.field_70461_c);
            return true;
        }
        if (slot >= 0 && slot < 9) {
            inventory.field_70461_c = slot;
            return true;
        }
        if (swapSlots && slot >= 9 && slot < 36 && this.swapSlots(inventory, slot)) {
            return this.swapToItem(inventory, itemStack, false);
        }
        return false;
    }

    private int getInventorySlotWithItem(InventoryPlayer inventory, ItemStack itemStack) {
        for (int i = 0; i < inventory.field_70462_a.size(); ++i) {
            if (!((ItemStack)inventory.field_70462_a.get(i)).func_77969_a(itemStack)) continue;
            return i;
        }
        return -1;
    }

    private boolean swapSlots(InventoryPlayer inventory, int from) {
        if (ConfigurationHandler.swapSlotsQueue.size() > 0) {
            int slot = this.getNextSlot();
            this.swapSlots(from, slot);
            return true;
        }
        return false;
    }

    private int getNextSlot() {
        int slot = ConfigurationHandler.swapSlotsQueue.poll() % 9;
        ConfigurationHandler.swapSlotsQueue.offer(slot);
        return slot;
    }

    private boolean swapSlots(int from, int to) {
        return this.minecraft.field_71442_b.func_187098_a(this.minecraft.field_71439_g.field_71069_bz.field_75152_c, from, to, ClickType.SWAP, (EntityPlayer)this.minecraft.field_71439_g) == ItemStack.field_190927_a;
    }
}

