/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.command;

import com.github.lunatrius.core.util.FileUtils;
import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.command.CommandSchematicaBase;
import com.github.lunatrius.schematica.reference.Reference;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.io.File;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CommandSchematicaRemove
extends CommandSchematicaBase {
    public String func_71517_b() {
        return "schematicaRemove";
    }

    public String func_71518_a(ICommandSender sender) {
        return "schematica.command.remove.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        File file;
        File schematicDirectory;
        String hash;
        String potentialNameHash;
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException("schematica.command.save.playersOnly", new Object[0]);
        }
        EntityPlayer player = (EntityPlayer)sender;
        boolean delete = false;
        String name = String.join((CharSequence)" ", args);
        if (args.length > 1 && (potentialNameHash = args[args.length - 1]).length() == 32) {
            CharSequence[] a = Arrays.copyOfRange(args, 0, args.length - 1);
            name = String.join((CharSequence)" ", a);
            hash = Hashing.md5().hashString((CharSequence)name, Charsets.UTF_8).toString();
            if (potentialNameHash.equals(hash)) {
                delete = true;
            }
        }
        if (!FileUtils.contains((File)(schematicDirectory = Schematica.proxy.getPlayerSchematicDirectory(player, true)), (File)(file = new File(schematicDirectory, name)))) {
            Reference.logger.error("{} has tried to download the file {}", (Object)player.func_70005_c_(), (Object)name);
            throw new CommandException("schematica.command.remove.schematicNotFound", new Object[0]);
        }
        if (!file.exists()) throw new CommandException("schematica.command.remove.schematicNotFound", new Object[0]);
        if (delete) {
            if (!file.delete()) throw new CommandException("schematica.command.remove.schematicNotFound", new Object[0]);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("schematica.command.remove.schematicRemoved", new Object[]{name}));
            return;
        } else {
            hash = Hashing.md5().hashString((CharSequence)name, Charsets.UTF_8).toString();
            String confirmCommand = String.format("/%s %s %s", "schematicaRemove", name, hash);
            TextComponentTranslation chatComponent = new TextComponentTranslation("schematica.command.remove.areYouSure", new Object[]{name});
            chatComponent.func_150257_a((ITextComponent)new TextComponentString(" ["));
            chatComponent.func_150257_a((ITextComponent)this.withStyle(new TextComponentTranslation("gui.yes", new Object[0]), TextFormatting.RED, confirmCommand));
            chatComponent.func_150257_a((ITextComponent)new TextComponentString("]"));
            sender.func_145747_a((ITextComponent)chatComponent);
        }
    }
}

