/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.command;

import com.github.lunatrius.core.util.math.MBlockPos;
import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.command.CommandSchematicaBase;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.schematic.SchematicFormat;
import java.io.File;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CommandSchematicaSave
extends CommandSchematicaBase {
    public String func_71517_b() {
        return "schematicaSave";
    }

    public String func_71518_a(ICommandSender sender) {
        return "schematica.command.save.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String filename;
        String format;
        String name;
        if (args.length < 7) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException("schematica.command.save.playersOnly", new Object[0]);
        }
        EntityPlayer player = (EntityPlayer)sender;
        if (Schematica.proxy.isPlayerQuotaExceeded(player)) {
            throw new CommandException("schematica.command.save.quotaExceeded", new Object[0]);
        }
        MBlockPos from = new MBlockPos();
        MBlockPos to = new MBlockPos();
        try {
            from.set(this.parseCoord(args[0]), this.parseCoord(args[1]), this.parseCoord(args[2]));
            to.set(this.parseCoord(args[3]), this.parseCoord(args[4]), this.parseCoord(args[5]));
            name = args[6];
            if (args.length >= 8) {
                format = args[7];
                if (!SchematicFormat.FORMATS.containsKey(format)) {
                    throw new CommandException("schematica.command.save.unknownFormat", new Object[]{format});
                }
            } else {
                format = null;
            }
            filename = name + SchematicFormat.getExtension(format);
        }
        catch (NumberFormatException exception) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        Reference.logger.debug("Saving schematic from {} to {} to {}", (Object)from, (Object)to, (Object)filename);
        File schematicDirectory = Schematica.proxy.getPlayerSchematicDirectory(player, true);
        if (schematicDirectory == null) {
            Reference.logger.warn("Unable to determine the schematic directory for player {}", (Object)player);
            throw new CommandException("schematica.command.save.playerSchematicDirUnavailable", new Object[0]);
        }
        if (!schematicDirectory.exists() && !schematicDirectory.mkdirs()) {
            Reference.logger.warn("Could not create player schematic directory {}", (Object)schematicDirectory.getAbsolutePath());
            throw new CommandException("schematica.command.save.playerSchematicDirUnavailable", new Object[0]);
        }
        try {
            Schematica.proxy.saveSchematic(player, schematicDirectory, filename, player.func_130014_f_(), format, (BlockPos)from, (BlockPos)to);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("schematica.command.save.saveSucceeded", new Object[]{name}));
        }
        catch (Exception e) {
            throw new CommandException("schematica.command.save.saveFailed", new Object[]{name});
        }
    }

    private int parseCoord(String argument) throws NumberInvalidException {
        return CommandSchematicaSave.func_175764_a((String)argument, (int)-30000000, (int)30000000);
    }
}

