/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.util;

import com.github.lunatrius.schematica.client.util.BlockList;
import com.github.lunatrius.schematica.reference.Reference;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public enum ItemStackSortType {
    NAME_ASC("name", "\u2191", (wrappedItemStackA, wrappedItemStackB) -> {
        String nameA = wrappedItemStackA.getItemStackDisplayName();
        String nameB = wrappedItemStackB.getItemStackDisplayName();
        return nameA.compareTo(nameB);
    }),
    NAME_DESC("name", "\u2193", (wrappedItemStackA, wrappedItemStackB) -> {
        String nameA = wrappedItemStackA.getItemStackDisplayName();
        String nameB = wrappedItemStackB.getItemStackDisplayName();
        return nameB.compareTo(nameA);
    }),
    SIZE_ASC("amount", "\u2191", (wrappedItemStackA, wrappedItemStackB) -> wrappedItemStackA.total - wrappedItemStackB.total),
    SIZE_DESC("amount", "\u2193", (wrappedItemStackA, wrappedItemStackB) -> wrappedItemStackB.total - wrappedItemStackA.total);

    private final Comparator<BlockList.WrappedItemStack> comparator;
    public final String label;
    public final String glyph;

    private ItemStackSortType(String label, String glyph, Comparator<BlockList.WrappedItemStack> comparator) {
        this.label = label;
        this.glyph = glyph;
        this.comparator = comparator;
    }

    public void sort(List<BlockList.WrappedItemStack> blockList) {
        try {
            Collections.sort(blockList, this.comparator);
        }
        catch (Exception e) {
            Reference.logger.error("Could not sort the block list!", (Throwable)e);
        }
    }

    public ItemStackSortType next() {
        ItemStackSortType[] values = ItemStackSortType.values();
        return values[(this.ordinal() + 1) % values.length];
    }

    public static ItemStackSortType fromString(String name) {
        try {
            return ItemStackSortType.valueOf(name);
        }
        catch (Exception exception) {
            return NAME_ASC;
        }
    }
}

