/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.world.schematic;

import com.github.lunatrius.core.util.math.MBlockPos;
import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.api.event.PreSchematicSaveEvent;
import com.github.lunatrius.schematica.nbt.NBTHelper;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.schematic.SchematicFormat;
import com.github.lunatrius.schematica.world.schematic.SchematicUtil;
import com.github.lunatrius.schematica.world.storage.Schematic;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SchematicAlpha
extends SchematicFormat {
    @Override
    public ISchematic readFromNBT(NBTTagCompound tagCompound) {
        ItemStack icon = SchematicUtil.getIconFromNBT(tagCompound);
        byte[] localBlocks = tagCompound.func_74770_j("Blocks");
        byte[] localMetadata = tagCompound.func_74770_j("Data");
        boolean extra = false;
        byte[] extraBlocks = null;
        byte[] extraBlocksNibble = null;
        if (tagCompound.func_74764_b("AddBlocks")) {
            extra = true;
            extraBlocksNibble = tagCompound.func_74770_j("AddBlocks");
            extraBlocks = new byte[extraBlocksNibble.length * 2];
            for (int i = 0; i < extraBlocksNibble.length; ++i) {
                extraBlocks[i * 2 + 0] = (byte)(extraBlocksNibble[i] >> 4 & 0xF);
                extraBlocks[i * 2 + 1] = (byte)(extraBlocksNibble[i] & 0xF);
            }
        } else if (tagCompound.func_74764_b("Add")) {
            extra = true;
            extraBlocks = tagCompound.func_74770_j("Add");
        }
        int width = tagCompound.func_74765_d("Width");
        int length = tagCompound.func_74765_d("Length");
        int height = tagCompound.func_74765_d("Height");
        Short id = null;
        HashMap<Short, Short> oldToNew = new HashMap<Short, Short>();
        if (tagCompound.func_74764_b("SchematicaMapping")) {
            NBTTagCompound mapping = tagCompound.func_74775_l("SchematicaMapping");
            Set names = mapping.func_150296_c();
            for (String name : names) {
                oldToNew.put(mapping.func_74765_d(name), (short)Block.field_149771_c.func_148757_b(Block.field_149771_c.func_82594_a((Object)new ResourceLocation(name))));
            }
        }
        MBlockPos pos = new MBlockPos();
        Schematic schematic = new Schematic(icon, width, height, length);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int index = x + (y * length + z) * width;
                    int blockID = localBlocks[index] & 0xFF | (extra ? (extraBlocks[index] & 0xFF) << 8 : 0);
                    int meta = localMetadata[index] & 0xFF;
                    id = (Short)oldToNew.get((short)blockID);
                    if (id != null) {
                        blockID = id.shortValue();
                    }
                    Block block = (Block)Block.field_149771_c.func_148754_a(blockID);
                    pos.set(x, y, z);
                    try {
                        IBlockState blockState = block.func_176203_a(meta);
                        schematic.setBlockState((BlockPos)pos, blockState);
                        continue;
                    }
                    catch (Exception e) {
                        Reference.logger.error("Could not set block state at {} to {} with metadata {}", (Object)pos, Block.field_149771_c.func_177774_c((Object)block), (Object)meta, (Object)e);
                    }
                }
            }
        }
        NBTTagList tileEntitiesList = tagCompound.func_150295_c("TileEntities", 10);
        for (int i = 0; i < tileEntitiesList.func_74745_c(); ++i) {
            try {
                TileEntity tileEntity = NBTHelper.readTileEntityFromCompound(tileEntitiesList.func_150305_b(i));
                if (tileEntity == null) continue;
                schematic.setTileEntity(tileEntity.func_174877_v(), tileEntity);
                continue;
            }
            catch (Exception e) {
                Reference.logger.error("TileEntity failed to load properly!", (Throwable)e);
            }
        }
        return schematic;
    }

    @Override
    public boolean writeToNBT(NBTTagCompound tagCompound, ISchematic schematic) {
        NBTTagCompound tagCompoundIcon = new NBTTagCompound();
        ItemStack icon = schematic.getIcon();
        icon.func_77955_b(tagCompoundIcon);
        tagCompound.func_74782_a("Icon", (NBTBase)tagCompoundIcon);
        tagCompound.func_74777_a("Width", (short)schematic.getWidth());
        tagCompound.func_74777_a("Length", (short)schematic.getLength());
        tagCompound.func_74777_a("Height", (short)schematic.getHeight());
        int size = schematic.getWidth() * schematic.getLength() * schematic.getHeight();
        byte[] localBlocks = new byte[size];
        byte[] localMetadata = new byte[size];
        byte[] extraBlocks = new byte[size];
        byte[] extraBlocksNibble = new byte[(int)Math.ceil((double)size / 2.0)];
        boolean extra = false;
        MBlockPos pos = new MBlockPos();
        HashMap<String, Short> mappings = new HashMap<String, Short>();
        for (int x = 0; x < schematic.getWidth(); ++x) {
            for (int y = 0; y < schematic.getHeight(); ++y) {
                for (int z = 0; z < schematic.getLength(); ++z) {
                    String name;
                    int index = x + (y * schematic.getLength() + z) * schematic.getWidth();
                    IBlockState blockState = schematic.getBlockState((BlockPos)pos.set(x, y, z));
                    Block block = blockState.func_177230_c();
                    int blockId = Block.field_149771_c.func_148757_b((Object)block);
                    localBlocks[index] = (byte)blockId;
                    localMetadata[index] = (byte)block.func_176201_c(blockState);
                    extraBlocks[index] = (byte)(blockId >> 8);
                    if (extraBlocks[index] > 0) {
                        extra = true;
                    }
                    if (mappings.containsKey(name = String.valueOf(Block.field_149771_c.func_177774_c((Object)block)))) continue;
                    mappings.put(name, (short)blockId);
                }
            }
        }
        int count = 20;
        NBTTagList tileEntitiesList = new NBTTagList();
        for (TileEntity tileEntity : schematic.getTileEntities()) {
            try {
                NBTTagCompound tileEntityTagCompound = NBTHelper.writeTileEntityToCompound(tileEntity);
                tileEntitiesList.func_74742_a((NBTBase)tileEntityTagCompound);
            }
            catch (Exception e) {
                BlockPos tePos = tileEntity.func_174877_v();
                int index = tePos.func_177958_n() + (tePos.func_177956_o() * schematic.getLength() + tePos.func_177952_p()) * schematic.getWidth();
                if (--count > 0) {
                    Block block;
                    IBlockState blockState = schematic.getBlockState(tePos);
                    Reference.logger.error("Block {}[{}] with TileEntity {} failed to save! Replacing with bedrock...", (Object)block, (block = blockState.func_177230_c()) != null ? Block.field_149771_c.func_177774_c((Object)block) : "?", (Object)tileEntity.getClass().getName(), (Object)e);
                }
                localBlocks[index] = (byte)Block.field_149771_c.func_148757_b((Object)Blocks.field_150357_h);
                localMetadata[index] = 0;
                extraBlocks[index] = 0;
            }
        }
        for (int i = 0; i < extraBlocksNibble.length; ++i) {
            extraBlocksNibble[i] = i * 2 + 1 < extraBlocks.length ? (byte)(extraBlocks[i * 2 + 0] << 4 | extraBlocks[i * 2 + 1]) : (byte)(extraBlocks[i * 2 + 0] << 4);
        }
        NBTTagList entityList = new NBTTagList();
        List<Entity> entities = schematic.getEntities();
        for (Entity entity : entities) {
            try {
                NBTTagCompound entityCompound = NBTHelper.writeEntityToCompound(entity);
                if (entityCompound == null) continue;
                entityList.func_74742_a((NBTBase)entityCompound);
            }
            catch (Throwable t) {
                Reference.logger.error("Entity {} failed to save, skipping!", (Object)entity, (Object)t);
            }
        }
        PreSchematicSaveEvent event = new PreSchematicSaveEvent(schematic, mappings);
        MinecraftForge.EVENT_BUS.post((Event)event);
        NBTTagCompound nbtMapping = new NBTTagCompound();
        for (Map.Entry entry : mappings.entrySet()) {
            nbtMapping.func_74777_a((String)entry.getKey(), ((Short)entry.getValue()).shortValue());
        }
        tagCompound.func_74778_a("Materials", "Alpha");
        tagCompound.func_74773_a("Blocks", localBlocks);
        tagCompound.func_74773_a("Data", localMetadata);
        if (extra) {
            tagCompound.func_74773_a("AddBlocks", extraBlocksNibble);
        }
        tagCompound.func_74782_a("Entities", (NBTBase)entityList);
        tagCompound.func_74782_a("TileEntities", (NBTBase)tileEntitiesList);
        tagCompound.func_74782_a("SchematicaMapping", (NBTBase)nbtMapping);
        NBTTagCompound extendedMetadata = event.extendedMetadata;
        if (!extendedMetadata.func_82582_d()) {
            tagCompound.func_74782_a("ExtendedMetadata", (NBTBase)extendedMetadata);
        }
        return true;
    }

    @Override
    public String getName() {
        return "schematica.format.alpha";
    }

    @Override
    public String getExtension() {
        return ".schematic";
    }
}

