/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.dataloader.sources;

import java.io.BufferedReader;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import net.darkhax.bookshelf.dataloader.DataLoader;
import net.darkhax.bookshelf.dataloader.sources.DataProviderMods;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FilenameUtils;

public class DataProviderModsOverridable
extends DataProviderMods {
    private final File overrideDir;

    public DataProviderModsOverridable(String modid) {
        this(new File("config/" + modid + "/overrides"), modid);
    }

    public DataProviderModsOverridable(File overrideDir, String ownerId) {
        super(ownerId);
        this.overrideDir = overrideDir;
        if (!this.overrideDir.exists()) {
            this.overrideDir.mkdirs();
        }
    }

    @Override
    protected void processFromPath(DataLoader loader, ModContainer mod, Path root, Path file, String processorType, BiConsumer<ResourceLocation, BufferedReader> processor) {
        String relative = root.relativize(file).toString();
        if (this.getPathValidator().test(file)) {
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            ResourceLocation entryId = new ResourceLocation(mod.getModId(), name);
            File potentialOverride = new File(this.overrideDir, entryId.func_110624_b() + "/" + processorType + "/" + FilenameUtils.getName((String)relative));
            if (potentialOverride.exists()) {
                file = potentialOverride.toPath();
            }
            try (BufferedReader reader = Files.newBufferedReader(file);){
                processor.accept(entryId, reader);
            }
            catch (Exception e) {
                loader.getLogger().error("Failed to read file {}. The file was not valid.", (Object)file);
                loader.getLogger().catching((Throwable)e);
            }
        }
    }
}

