/*
 * Decompiled with CFR 0.152.
 */
package net.kineticnetwork.core.objects.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.kineticnetwork.core.init.blockinit;
import net.kineticnetwork.core.init.iteminit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClearKinetic
extends Block {
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool[] ALL_FACES = new PropertyBool[]{UP, NORTH, SOUTH, WEST, EAST};
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);

    public ClearKinetic(String name, Material material) {
        super(material);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        blockinit.BLOCKS.add(this);
        iteminit.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        int i = 0;
        AxisAlignedBB axisalignedbb = field_185505_j;
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            axisalignedbb = UP_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            axisalignedbb = NORTH_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            axisalignedbb = EAST_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            axisalignedbb = SOUTH_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            axisalignedbb = WEST_AABB;
            ++i;
        }
        return i == 1 ? axisalignedbb : field_185505_j;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177984_a();
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(worldIn.func_180495_p(blockpos).func_193401_d(worldIn, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.DOWN && side != EnumFacing.UP && this.canAttachTo(worldIn, pos, side);
    }

    public boolean canAttachTo(World p_193395_1_, BlockPos p_193395_2_, EnumFacing p_193395_3_) {
        Block block = p_193395_1_.func_180495_p(p_193395_2_.func_177984_a()).func_177230_c();
        return this.isAcceptableNeighbor(p_193395_1_, p_193395_2_.func_177972_a(p_193395_3_.func_176734_d()), p_193395_3_) && (block == Blocks.field_150350_a || block == Blocks.field_150395_bd || this.isAcceptableNeighbor(p_193395_1_, p_193395_2_.func_177984_a(), EnumFacing.UP));
    }

    private boolean isAcceptableNeighbor(World p_193396_1_, BlockPos p_193396_2_, EnumFacing p_193396_3_) {
        IBlockState iblockstate = p_193396_1_.func_180495_p(p_193396_2_);
        return iblockstate.func_193401_d((IBlockAccess)p_193396_1_, p_193396_2_, p_193396_3_) == BlockFaceShape.SOLID && !ClearKinetic.isExceptBlockForAttaching(iblockstate.func_177230_c());
    }

    protected static boolean isExceptBlockForAttaching(Block p_193397_0_) {
        return p_193397_0_ instanceof BlockShulkerBox || p_193397_0_ == Blocks.field_150461_bJ || p_193397_0_ == Blocks.field_150383_bp || p_193397_0_ == Blocks.field_150359_w || p_193397_0_ == Blocks.field_150399_cn || p_193397_0_ == Blocks.field_150331_J || p_193397_0_ == Blocks.field_150320_F || p_193397_0_ == Blocks.field_150332_K || p_193397_0_ == Blocks.field_150415_aT;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false));
        return facing.func_176740_k().func_176722_c() ? iblockstate.func_177226_a((IProperty)ClearKinetic.getPropertyFor(facing.func_176734_d()), (Comparable)Boolean.valueOf(true)) : iblockstate;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf((meta & 1) > 0)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf((meta & 2) > 0)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf((meta & 4) > 0)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= 1;
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= 2;
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, NORTH, EAST, SOUTH, WEST});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    public static PropertyBool getPropertyFor(EnumFacing side) {
        switch (side) {
            case UP: {
                return UP;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case EAST: {
                return EAST;
            }
        }
        throw new IllegalArgumentException(side + " is an invalid choice");
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

