/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_mail.client;

import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.common.persistent.AbstractPersistentData;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_mail.common.Mail;
import austeretony.oxygen_mail.common.config.MailConfig;
import io.netty.util.internal.ConcurrentSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MailboxContainerClient
extends AbstractPersistentData {
    private final Map<Long, Mail> mail = new ConcurrentHashMap<Long, Mail>();
    private final Set<Long> read = new ConcurrentSet();

    public int getMessagesAmount() {
        return this.mail.size();
    }

    public Collection<Mail> getMessages() {
        return this.mail.values();
    }

    public Set<Long> getMessagesIds() {
        return this.mail.keySet();
    }

    public Mail getMessage(long messageId) {
        return this.mail.get(messageId);
    }

    public void addMessage(Mail message) {
        this.mail.put(message.getId(), message);
    }

    public void removeMessage(long messageId) {
        this.mail.remove(messageId);
    }

    public boolean isMarkedAsRead(long messageId) {
        return this.read.contains(messageId);
    }

    public void markAsRead(long messageId) {
        this.read.add(messageId);
    }

    public void removeReadMark(long messageId) {
        this.read.remove(messageId);
    }

    public String getDisplayName() {
        return "mailbox";
    }

    public String getPath() {
        return OxygenHelperClient.getDataFolder() + "/client/players/" + OxygenHelperClient.getPlayerUUID() + "/mail/mailbox.dat";
    }

    public long getSaveDelayMinutes() {
        return MailConfig.MAIL_SAVE_DELAY_MINUTES.getIntValue();
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((short)((short)this.mail.size()), (OutputStream)bos);
        for (Mail message : this.mail.values()) {
            message.write(bos);
        }
        StreamUtils.write((short)((short)this.read.size()), (OutputStream)bos);
        Iterator<Object> iterator = this.read.iterator();
        while (iterator.hasNext()) {
            long messageId = (Long)iterator.next();
            StreamUtils.write((long)messageId, (OutputStream)bos);
        }
    }

    public void read(BufferedInputStream bis) throws IOException {
        int i;
        int amount = StreamUtils.readShort((InputStream)bis);
        for (i = 0; i < amount; ++i) {
            Mail message = new Mail();
            message.read(bis);
            this.mail.put(message.getId(), message);
        }
        amount = StreamUtils.readShort((InputStream)bis);
        for (i = 0; i < amount; ++i) {
            this.read.add(StreamUtils.readLong((InputStream)bis));
        }
    }

    public void reset() {
        this.mail.clear();
    }
}

