/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_mail.client.gui.mail;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.contextmenu.GUIContextMenu;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.screen.text.GUITextBoxLabel;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.OxygenGUIHelper;
import austeretony.oxygen_core.client.api.PrivilegeProviderClient;
import austeretony.oxygen_core.client.api.WatcherHelperClient;
import austeretony.oxygen_core.client.gui.elements.CurrencyValueGUIElement;
import austeretony.oxygen_core.client.gui.elements.InventoryLoadGUIElement;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButtonPanel;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIContextMenu;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIContextMenuElement;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.elements.OxygenSorterGUIElement;
import austeretony.oxygen_core.client.gui.elements.SectionsGUIDDList;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.inventory.InventoryHelper;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_core.common.util.OxygenUtils;
import austeretony.oxygen_mail.client.MailManagerClient;
import austeretony.oxygen_mail.client.gui.mail.MailMenuGUIScreen;
import austeretony.oxygen_mail.client.gui.mail.incoming.AttachmentGUIElement;
import austeretony.oxygen_mail.client.gui.mail.incoming.IncomingBackgroundGUIFiller;
import austeretony.oxygen_mail.client.gui.mail.incoming.MessageGUIButton;
import austeretony.oxygen_mail.client.gui.mail.incoming.callback.RemoveMessageGUICallback;
import austeretony.oxygen_mail.client.gui.mail.incoming.callback.ReturnAttachmentGUICallback;
import austeretony.oxygen_mail.client.gui.mail.incoming.callback.TakeAttachmentGUICallback;
import austeretony.oxygen_mail.client.gui.mail.incoming.context.RemoveMessageContextAction;
import austeretony.oxygen_mail.client.gui.mail.incoming.context.ReturnAttachmentContextAction;
import austeretony.oxygen_mail.client.gui.mail.incoming.context.TakeAttachmentContextAction;
import austeretony.oxygen_mail.client.input.MailKeyHandler;
import austeretony.oxygen_mail.common.EnumMail;
import austeretony.oxygen_mail.common.Mail;
import austeretony.oxygen_mail.common.Parcel;
import austeretony.oxygen_mail.common.config.MailConfig;
import austeretony.oxygen_mail.common.main.EnumMailPrivilege;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class IncomingGUISection
extends AbstractGUISection {
    private final MailMenuGUIScreen screen;
    private OxygenSorterGUIElement timeSorterElement;
    private OxygenSorterGUIElement subjectSorterElement;
    private OxygenGUIButtonPanel messagesPanel;
    private OxygenGUIText messagesAmountLabel;
    private InventoryLoadGUIElement inventoryLoadElement;
    private CurrencyValueGUIElement balanceElement;
    private AbstractGUICallback takeAttachmentCallback;
    private AbstractGUICallback returnAttachmentCallback;
    private AbstractGUICallback removeMessageCallback;
    private OxygenGUIText senderTextLabel;
    private OxygenGUIText receiveTimeTextLabel;
    private OxygenGUIText expireTimeTextLabel;
    private OxygenGUIText messageSubjectTextLabel;
    private OxygenGUIText attachmentTitleTextLabel;
    private OxygenGUIText codCostTextLabel;
    private GUITextBoxLabel messageTextBoxLabel;
    private AttachmentGUIElement attachmentElement;
    private MessageGUIButton currentMessageButton;
    private Mail currentMessage;

    public IncomingGUISection(MailMenuGUIScreen screen) {
        super((AbstractGUIScreen)screen);
        this.screen = screen;
    }

    public void init() {
        this.addElement((GUIBaseElement)new IncomingBackgroundGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, ClientReference.localize((String)"oxygen_mail.gui.mail.title", (Object[])new Object[0]), GUISettings.get().getTitleScale(), GUISettings.get().getEnabledTextColor()));
        this.addElement((GUIBaseElement)new SectionsGUIDDList(this.getWidth() - 4, 5, new AbstractGUISection[]{this, this.screen.getSendingSection()}));
        this.messagesAmountLabel = new OxygenGUIText(0, 18, "", GUISettings.get().getSubTextScale() - 0.05f, GUISettings.get().getEnabledTextColor());
        this.addElement((GUIBaseElement)this.messagesAmountLabel);
        this.timeSorterElement = new OxygenSorterGUIElement(6, 18, OxygenSorterGUIElement.EnumSorting.DOWN, ClientReference.localize((String)"oxygen_mail.sorting.receiveTime", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.timeSorterElement);
        this.timeSorterElement.setClickListener(sorting -> {
            this.subjectSorterElement.reset();
            if (sorting == OxygenSorterGUIElement.EnumSorting.DOWN) {
                this.sortMail(0);
            } else {
                this.sortMail(1);
            }
        });
        this.subjectSorterElement = new OxygenSorterGUIElement(12, 18, OxygenSorterGUIElement.EnumSorting.INACTIVE, ClientReference.localize((String)"oxygen_mail.sorting.subject", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.subjectSorterElement);
        this.subjectSorterElement.setClickListener(sorting -> {
            this.timeSorterElement.reset();
            if (sorting == OxygenSorterGUIElement.EnumSorting.DOWN) {
                this.sortMail(2);
            } else {
                this.sortMail(3);
            }
        });
        int maxRows = MathUtils.clamp((int)MailManagerClient.instance().getMailboxContainer().getMessagesAmount(), (int)11, (int)PrivilegeProviderClient.getValue((String)EnumMailPrivilege.MAILBOX_SIZE.toString(), (int)MailConfig.MAILBOX_SIZE.getIntValue()));
        this.messagesPanel = new OxygenGUIButtonPanel((AbstractGUIScreen)this.screen, 6, 24, 75, 11, 1, maxRows, 11, GUISettings.get().getPanelTextScale(), true);
        this.addElement((GUIBaseElement)this.messagesPanel);
        this.messagesPanel.setClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            if (this.currentMessageButton != clicked) {
                if (this.currentMessageButton != null) {
                    this.currentMessageButton.setToggled(false);
                }
                clicked.toggle();
                this.currentMessageButton = clicked;
                this.resetMessageContent();
                this.loadMessageContent((Long)clicked.index);
                if (!MailManagerClient.instance().getMailboxContainer().isMarkedAsRead((Long)clicked.index)) {
                    MailManagerClient.instance().getMailboxContainer().markAsRead((Long)clicked.index);
                    MailManagerClient.instance().getMailboxContainer().setChanged(true);
                    clicked.read();
                }
            }
        });
        this.messagesPanel.initContextMenu((GUIContextMenu)new OxygenGUIContextMenu(GUISettings.get().getContextMenuWidth(), 9, new OxygenGUIContextMenuElement.ContextMenuAction[]{new TakeAttachmentContextAction(this), new ReturnAttachmentContextAction(this), new RemoveMessageContextAction(this)}));
        this.inventoryLoadElement = new InventoryLoadGUIElement(4, this.getHeight() - 9, EnumGUIAlignment.RIGHT);
        this.addElement((GUIBaseElement)this.inventoryLoadElement);
        this.inventoryLoadElement.updateLoad();
        this.balanceElement = new CurrencyValueGUIElement(this.getWidth() - 10, this.getHeight() - 10);
        this.addElement((GUIBaseElement)this.balanceElement);
        this.balanceElement.setValue(WatcherHelperClient.getLong((int)0));
        this.takeAttachmentCallback = new TakeAttachmentGUICallback(this.screen, this, 140, 38).enableDefaultBackground();
        this.returnAttachmentCallback = new ReturnAttachmentGUICallback(this.screen, this, 140, 38).enableDefaultBackground();
        this.removeMessageCallback = new RemoveMessageGUICallback(this.screen, this, 140, 38).enableDefaultBackground();
        this.initMessageElements();
    }

    private void initMessageElements() {
        this.senderTextLabel = (OxygenGUIText)new OxygenGUIText(87, 18, "", GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()).disableFull();
        this.addElement((GUIBaseElement)this.senderTextLabel);
        this.receiveTimeTextLabel = (OxygenGUIText)new OxygenGUIText(87, 26, "", GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()).disableFull();
        this.addElement((GUIBaseElement)this.receiveTimeTextLabel);
        this.expireTimeTextLabel = (OxygenGUIText)new OxygenGUIText(87, 34, "", GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()).disableFull();
        this.addElement((GUIBaseElement)this.expireTimeTextLabel);
        this.messageSubjectTextLabel = (OxygenGUIText)new OxygenGUIText(87, 44, "", GUISettings.get().getTextScale(), GUISettings.get().getEnabledTextColor()).disableFull();
        this.addElement((GUIBaseElement)this.messageSubjectTextLabel);
        this.messageTextBoxLabel = (GUITextBoxLabel)((GUITextBoxLabel)((GUITextBoxLabel)new GUITextBoxLabel(88, 54, 120, 84).setEnabledTextColor(GUISettings.get().getEnabledTextColor())).setTextScale(GUISettings.get().getSubTextScale())).setLineOffset(2).disableFull();
        this.addElement((GUIBaseElement)this.messageTextBoxLabel);
        this.attachmentElement = (AttachmentGUIElement)new AttachmentGUIElement(87, 139).disableFull();
        this.addElement((GUIBaseElement)this.attachmentElement);
    }

    private void sortMail(int mode) {
        this.resetMessageContent();
        ArrayList<Mail> mail = new ArrayList<Mail>(MailManagerClient.instance().getMailboxContainer().getMessages());
        if (mode == 0) {
            Collections.sort(mail, (m1, m2) -> (int)((m2.getId() - m1.getId()) / 10000L));
        } else if (mode == 1) {
            Collections.sort(mail, (m1, m2) -> (int)((m1.getId() - m2.getId()) / 10000L));
        } else if (mode == 2) {
            Collections.sort(mail, (m1, m2) -> m1.getLocalizedSubject().compareTo(m2.getLocalizedSubject()));
        } else if (mode == 3) {
            Collections.sort(mail, (m1, m2) -> m2.getLocalizedSubject().compareTo(m1.getLocalizedSubject()));
        }
        this.messagesPanel.reset();
        for (Mail msg : mail) {
            this.messagesPanel.addButton((GUIButton)new MessageGUIButton(msg));
        }
        this.messagesAmountLabel.setDisplayText(String.valueOf(MailManagerClient.instance().getMailboxContainer().getMessagesAmount()) + "/" + String.valueOf(PrivilegeProviderClient.getValue((String)EnumMailPrivilege.MAILBOX_SIZE.toString(), (int)MailConfig.MAILBOX_SIZE.getIntValue())));
        this.messagesAmountLabel.setX(80 - this.textWidth(this.messagesAmountLabel.getDisplayText(), GUISettings.get().getSubTextScale() - 0.05f));
        this.messagesPanel.getScroller().resetPosition();
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        if (!this.hasCurrentCallback()) {
            if (OxygenGUIHelper.isOxygenMenuEnabled()) {
                if (keyCode == MailMenuGUIScreen.MAIL_MENU_ENTRY.getIndex() + 2) {
                    this.screen.close();
                }
            } else if (keyCode == MailKeyHandler.MAIL_MENU.func_151463_i()) {
                this.screen.close();
            }
        }
        return super.keyTyped(typedChar, keyCode);
    }

    private void loadMessageContent(long messageId) {
        this.currentMessage = MailManagerClient.instance().getMailboxContainer().getMessage(messageId);
        this.senderTextLabel.setDisplayText(ClientReference.localize((String)"oxygen_mail.gui.mail.msg.sender", (Object[])new Object[]{this.currentMessage.getLocalizedSenderName()}));
        this.senderTextLabel.enableFull();
        this.expireTimeTextLabel.setDisplayText(ClientReference.localize((String)"oxygen_mail.gui.mail.msg.expires", (Object[])new Object[]{IncomingGUISection.getExpirationTimeLocalizedString(this.currentMessage.getType(), this.currentMessage.getId())}));
        this.expireTimeTextLabel.enableFull();
        this.receiveTimeTextLabel.setDisplayText(ClientReference.localize((String)"oxygen_mail.gui.mail.msg.received", (Object[])new Object[]{OxygenUtils.getTimePassedLocalizedString((long)this.currentMessage.getId())}));
        this.receiveTimeTextLabel.enableFull();
        this.messageSubjectTextLabel.setDisplayText(ClientReference.localize((String)this.currentMessage.getSubject(), (Object[])new Object[0]));
        this.messageSubjectTextLabel.enableFull();
        this.messageTextBoxLabel.setDisplayText(ClientReference.localize((String)this.currentMessage.getMessage(), (Object[])new Object[0]));
        this.messageTextBoxLabel.enableFull();
        if (this.currentMessage.isPending()) {
            this.attachmentElement.load(this.currentMessage);
            this.attachmentElement.enableFull();
            if (this.currentMessage.getType() == EnumMail.PACKAGE_WITH_COD && this.balanceElement.getValue() < this.currentMessage.getCurrency()) {
                this.attachmentElement.disable();
            }
            if (!this.currentMessage.isPending()) {
                this.attachmentElement.disableFull();
            }
        }
    }

    private void resetMessageContent() {
        this.senderTextLabel.disableFull();
        this.expireTimeTextLabel.disableFull();
        this.receiveTimeTextLabel.disableFull();
        this.messageSubjectTextLabel.disableFull();
        this.messageTextBoxLabel.disableFull();
        this.attachmentElement.disableFull();
    }

    public MessageGUIButton getCurrentMessageButton() {
        return this.currentMessageButton;
    }

    public Mail getCurrentMessage() {
        return this.currentMessage;
    }

    private static String getExpirationTimeLocalizedString(EnumMail type, long millis) {
        int expiresIn = -1;
        switch (type) {
            case SYSTEM_LETTER: {
                expiresIn = MailConfig.SYSTEM_LETTER_EXPIRE_TIME_HOURS.getIntValue();
                break;
            }
            case LETTER: {
                expiresIn = MailConfig.LETTER_EXPIRE_TIME_HOURS.getIntValue();
                break;
            }
            case SYSTEM_REMITTANCE: {
                expiresIn = MailConfig.SYSTEM_REMITTANCE_EXPIRE_TIME_HOURS.getIntValue();
                break;
            }
            case REMITTANCE: {
                expiresIn = MailConfig.REMITTANCE_EXPIRE_TIME_HOURS.getIntValue();
                break;
            }
            case SYSTEM_PACKAGE: {
                expiresIn = MailConfig.SYSTEM_PACKAGE_EXPIRE_TIME_HOURS.getIntValue();
                break;
            }
            case PACKAGE: {
                expiresIn = MailConfig.PACKAGE_EXPIRE_TIME_HOURS.getIntValue();
                break;
            }
            case PACKAGE_WITH_COD: {
                expiresIn = MailConfig.PACKAGE_WITH_COD_EXPIRE_TIME_HOURS.getIntValue();
            }
        }
        if (expiresIn < 0) {
            return ClientReference.localize((String)"oxygen_mail.gui.neverExpires", (Object[])new Object[0]);
        }
        return OxygenUtils.getExpirationTimeLocalizedString((long)((long)expiresIn * 3600000L), (long)millis);
    }

    public void sharedDataSynchronized() {
    }

    public void mailSynchronized() {
        this.sortMail(0);
    }

    public void messageSent(Parcel parcel, long balance) {
        this.balanceElement.setValue(balance);
        if (parcel != null) {
            InventoryHelper.removeEqualStack((EntityPlayer)this.mc.field_71439_g, (ItemStack)parcel.stackWrapper.getItemStack(), (int)parcel.amount);
            this.inventoryLoadElement.updateLoad();
            this.screen.updateInventoryContent();
        }
    }

    public void messageRemoved(long messageId) {
        this.timeSorterElement.setSorting(OxygenSorterGUIElement.EnumSorting.DOWN);
        this.subjectSorterElement.reset();
        this.sortMail(0);
    }

    public void attachmentReceived(long oldMessageId, Parcel parcel, long balance) {
        this.balanceElement.setValue(balance);
        if (parcel != null) {
            InventoryHelper.addItemStack((EntityPlayer)this.mc.field_71439_g, (ItemStack)parcel.stackWrapper.getItemStack(), (int)parcel.amount);
            this.inventoryLoadElement.updateLoad();
            this.screen.updateInventoryContent();
        }
        if (this.currentMessage != null && this.currentMessage.getId() == oldMessageId) {
            this.currentMessageButton.setPending(false);
            this.currentMessage.setPending(false);
            this.attachmentElement.disableFull();
        }
    }

    public InventoryLoadGUIElement getInventoryLoadElement() {
        return this.inventoryLoadElement;
    }

    public CurrencyValueGUIElement getBalanceElement() {
        return this.balanceElement;
    }

    public void openTakeAttachmentCallback() {
        this.takeAttachmentCallback.open();
    }

    public void openReturnAttachmentCallback() {
        this.returnAttachmentCallback.open();
    }

    public void openRemoveMessageCallback() {
        this.removeMessageCallback.open();
    }
}

