/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_mail.client.gui.mail;

import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.screen.core.GUIWorkspace;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.gui.menu.OxygenMenuEntry;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_mail.client.gui.mail.IncomingGUISection;
import austeretony.oxygen_mail.client.gui.mail.MailMenuEntry;
import austeretony.oxygen_mail.client.gui.mail.SendingGUISection;
import austeretony.oxygen_mail.common.Parcel;
import austeretony.oxygen_mail.common.main.EnumMailStatusMessage;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class MailMenuGUIScreen
extends AbstractGUIScreen {
    public static final OxygenMenuEntry MAIL_MENU_ENTRY = new MailMenuEntry();
    protected IncomingGUISection incomingSection;
    protected SendingGUISection sendingSection;
    public final Map<ItemStackWrapper, Integer> inventoryContent;

    public MailMenuGUIScreen() {
        OxygenHelperClient.syncSharedData((int)80);
        OxygenHelperClient.syncData((int)80);
        this.inventoryContent = new LinkedHashMap<ItemStackWrapper, Integer>();
        this.updateInventoryContent();
    }

    protected GUIWorkspace initWorkspace() {
        return new GUIWorkspace((AbstractGUIScreen)this, 213, 170).setAlignment(EnumGUIAlignment.RIGHT, -10, 0);
    }

    protected void initSections() {
        this.incomingSection = (IncomingGUISection)((AbstractGUISection)new IncomingGUISection(this).setDisplayText(ClientReference.localize((String)"oxygen_mail.gui.mail.incoming", (Object[])new Object[0]))).enable();
        this.getWorkspace().initSection((AbstractGUISection)this.incomingSection);
        this.sendingSection = (SendingGUISection)((AbstractGUISection)new SendingGUISection(this).setDisplayText(ClientReference.localize((String)"oxygen_mail.gui.mail.sending", (Object[])new Object[0]))).enable();
        this.getWorkspace().initSection((AbstractGUISection)this.sendingSection);
    }

    protected AbstractGUISection getDefaultSection() {
        return this.incomingSection;
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element) {
    }

    protected boolean doesGUIPauseGame() {
        return false;
    }

    public void informPlayer(EnumMailStatusMessage status) {
        OxygenManagerClient.instance().getChatMessagesManager().showStatusMessage(8, status.ordinal());
    }

    public void updateInventoryContent() {
        this.inventoryContent.clear();
        for (ItemStack itemStack : ClientReference.getClientPlayer().field_71071_by.field_70462_a) {
            if (itemStack.func_190926_b()) continue;
            ItemStackWrapper wrapper = ItemStackWrapper.getFromStack((ItemStack)itemStack);
            if (!this.inventoryContent.containsKey(wrapper)) {
                this.inventoryContent.put(wrapper, itemStack.func_190916_E());
                continue;
            }
            int amount = this.inventoryContent.get(wrapper);
            this.inventoryContent.put(wrapper, amount += itemStack.func_190916_E());
        }
    }

    public int getEqualStackAmount(ItemStackWrapper stackWrapper) {
        int amount = 0;
        for (ItemStackWrapper wrapper : this.inventoryContent.keySet()) {
            if (!wrapper.isEquals(stackWrapper)) continue;
            amount += this.inventoryContent.get(wrapper).intValue();
        }
        return amount;
    }

    public void sharedDataSynchronized() {
        this.incomingSection.sharedDataSynchronized();
        this.sendingSection.sharedDataSynchronized();
    }

    public void mailSynchronized() {
        this.incomingSection.mailSynchronized();
        this.sendingSection.mailSynchronized();
    }

    public void messageSent(Parcel parcel, long balance) {
        this.incomingSection.messageSent(parcel, balance);
        this.sendingSection.messageSent(parcel, balance);
    }

    public void messageRemoved(long messageId) {
        this.incomingSection.messageRemoved(messageId);
        this.sendingSection.messageRemoved(messageId);
    }

    public void attachmentReceived(long oldMessageId, Parcel parcel, long balance) {
        this.incomingSection.attachmentReceived(oldMessageId, parcel, balance);
        this.sendingSection.attachmentReceived(oldMessageId, parcel, balance);
    }

    public IncomingGUISection getIncomingSection() {
        return this.incomingSection;
    }

    public SendingGUISection getSendingSection() {
        return this.sendingSection;
    }
}

