/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_mail.client.gui.mail;

import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.screen.text.GUITextBoxField;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.PrivilegeProviderClient;
import austeretony.oxygen_core.client.gui.elements.CurrencyValueGUIElement;
import austeretony.oxygen_core.client.gui.elements.InventoryLoadGUIElement;
import austeretony.oxygen_core.client.gui.elements.OxygenCheckBoxGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.elements.OxygenGUITextField;
import austeretony.oxygen_core.client.gui.elements.SectionsGUIDDList;
import austeretony.oxygen_core.client.gui.elements.UsernameGUITextField;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_mail.client.gui.mail.MailMenuGUIScreen;
import austeretony.oxygen_mail.client.gui.mail.sending.InventoryItemGUIButton;
import austeretony.oxygen_mail.client.gui.mail.sending.SendingBackgroundGUIFiller;
import austeretony.oxygen_mail.client.gui.mail.sending.callback.SelectItemGUICallback;
import austeretony.oxygen_mail.client.gui.mail.sending.callback.SendMessageGUICallback;
import austeretony.oxygen_mail.common.EnumMail;
import austeretony.oxygen_mail.common.Mail;
import austeretony.oxygen_mail.common.Parcel;
import austeretony.oxygen_mail.common.config.MailConfig;
import austeretony.oxygen_mail.common.main.EnumMailPrivilege;
import java.util.UUID;
import net.minecraft.item.ItemStack;

public class SendingGUISection
extends AbstractGUISection {
    private final MailMenuGUIScreen screen;
    private OxygenGUIButton selectItemButton;
    private OxygenGUIButton sendButton;
    private UsernameGUITextField addresseeTextField;
    private OxygenGUITextField subjectTextField;
    private OxygenGUITextField currencyTextField;
    private OxygenGUITextField packageAmountTextField;
    private GUITextBoxField messageTextBoxField;
    private OxygenCheckBoxGUIButton enableRemittanceButton;
    private OxygenCheckBoxGUIButton enableCODButton;
    private OxygenCheckBoxGUIButton enablePackageButton;
    private InventoryLoadGUIElement inventoryLoadElement;
    private CurrencyValueGUIElement balanceElement;
    private AbstractGUICallback selectItemCallback;
    private AbstractGUICallback sendMessageCallback;
    private InventoryItemGUIButton currentItemButton;
    private final String playerFoundStr = ClientReference.localize((String)"oxygen_mail.gui.mail.playerOnline", (Object[])new Object[0]);
    private final String playerNotFoundStr = ClientReference.localize((String)"oxygen_mail.gui.mail.playerOffline", (Object[])new Object[0]);

    public SendingGUISection(MailMenuGUIScreen screen) {
        super((AbstractGUIScreen)screen);
        this.screen = screen;
    }

    public void init() {
        this.addElement((GUIBaseElement)new SendingBackgroundGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, ClientReference.localize((String)"oxygen_mail.gui.mail.title", (Object[])new Object[0]), GUISettings.get().getTitleScale(), GUISettings.get().getEnabledTextColor()));
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 40, ClientReference.localize((String)"oxygen_mail.gui.mail.subject", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.subjectTextField = new OxygenGUITextField(6, 47, 120, 9, 24, "", 3, false, -1L);
        this.addElement((GUIBaseElement)this.subjectTextField);
        this.messageTextBoxField = (GUITextBoxField)((GUITextBoxField)((GUITextBoxField)new GUITextBoxField(6, 58, 120, 84, 800).setLineOffset(2).setTextScale(GUISettings.get().getSubTextScale())).enableDynamicBackground()).cancelDraggedElementLogic(true);
        this.addElement((GUIBaseElement)this.messageTextBoxField);
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 18, ClientReference.localize((String)"oxygen_mail.gui.mail.sendTo", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.addresseeTextField = new UsernameGUITextField(6, 25, 120);
        this.addElement((GUIBaseElement)this.addresseeTextField);
        this.addresseeTextField.disable();
        this.addElement((GUIBaseElement)new OxygenGUIText(130, 18, ClientReference.localize((String)"oxygen_mail.gui.mail.attachment", (Object[])new Object[0]), GUISettings.get().getTextScale(), GUISettings.get().getEnabledTextColor()));
        this.enableRemittanceButton = new OxygenCheckBoxGUIButton(130, 27);
        this.addElement((GUIBaseElement)this.enableRemittanceButton);
        this.addElement((GUIBaseElement)new OxygenGUIText(139, 28, ClientReference.localize((String)"oxygen_mail.gui.mail.remittance", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.enableCODButton = new OxygenCheckBoxGUIButton(130, 37);
        this.addElement((GUIBaseElement)this.enableCODButton);
        this.addElement((GUIBaseElement)new OxygenGUIText(139, 38, ClientReference.localize((String)"oxygen_mail.gui.mail.cod", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.currencyTextField = new OxygenGUITextField(130, 46, 45, 9, 10, "0", 3, true, -1L);
        this.addElement((GUIBaseElement)this.currencyTextField);
        this.currencyTextField.disable();
        this.enablePackageButton = new OxygenCheckBoxGUIButton(130, 64);
        this.addElement((GUIBaseElement)this.enablePackageButton);
        this.addElement((GUIBaseElement)new OxygenGUIText(139, 65, ClientReference.localize((String)"oxygen_mail.gui.mail.package", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.packageAmountTextField = new OxygenGUITextField(130, 73, 45, 9, 4, "0", 3, true, -1L);
        this.addElement((GUIBaseElement)this.packageAmountTextField);
        this.selectItemButton = (OxygenGUIButton)new OxygenGUIButton(130, 85, 40, 10, ClientReference.localize((String)"oxygen_mail.gui.mail.selectItemButton", (Object[])new Object[0])).disable();
        this.addElement((GUIBaseElement)this.selectItemButton);
        this.packageAmountTextField.disable();
        this.sendButton = (OxygenGUIButton)new OxygenGUIButton(6, this.getHeight() - 26, 40, 10, ClientReference.localize((String)"oxygen_mail.gui.mail.sendButton", (Object[])new Object[0])).disable();
        this.addElement((GUIBaseElement)this.sendButton);
        this.inventoryLoadElement = new InventoryLoadGUIElement(4, this.getHeight() - 9, EnumGUIAlignment.RIGHT);
        this.addElement((GUIBaseElement)this.inventoryLoadElement);
        this.inventoryLoadElement.setLoad(this.screen.getIncomingSection().getInventoryLoadElement().getLoad());
        this.balanceElement = new CurrencyValueGUIElement(this.getWidth() - 10, this.getHeight() - 10);
        this.addElement((GUIBaseElement)this.balanceElement);
        this.balanceElement.setValue(this.screen.getIncomingSection().getBalanceElement().getValue());
        this.addElement((GUIBaseElement)new SectionsGUIDDList(this.getWidth() - 4, 5, new AbstractGUISection[]{this, this.screen.getIncomingSection()}));
        this.selectItemCallback = new SelectItemGUICallback(this.screen, this, 140, 96).enableDefaultBackground();
        this.sendMessageCallback = new SendMessageGUICallback(this.screen, this, 140, 76).enableDefaultBackground();
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0) {
            if (!this.addresseeTextField.getTypedText().isEmpty() && !this.subjectTextField.getTypedText().isEmpty()) {
                this.sendButton.enable();
            } else {
                this.sendButton.disable();
            }
            if (element == this.selectItemButton) {
                this.selectItemCallback.open();
            } else if (element == this.sendButton) {
                this.sendMessageCallback.open();
            } else if (element == this.enableRemittanceButton) {
                if (this.enableRemittanceButton.isToggled()) {
                    this.currencyTextField.enableNumberFieldMode(MathUtils.lesserOfTwo((long)this.balanceElement.getValue(), (long)PrivilegeProviderClient.getValue((String)EnumMailPrivilege.REMITTANCE_MAX_VALUE.toString(), (long)MailConfig.REMITTANCE_MAX_VALUE.getLongValue())));
                    this.enableCODButton.setToggled(false);
                    this.currencyTextField.enable();
                } else {
                    this.currencyTextField.disable();
                }
                this.currencyTextField.setText("0");
                this.packageAmountTextField.setText("0");
                if (this.enablePackageButton.isToggled()) {
                    this.enablePackageButton.setToggled(false);
                    this.packageAmountTextField.disable();
                    if (this.currentItemButton != null) {
                        this.currentItemButton.setToggled(false);
                    }
                    this.currentItemButton = null;
                }
            } else if (element == this.enableCODButton) {
                if (this.enableCODButton.isToggled()) {
                    this.selectItemButton.enable();
                    this.currencyTextField.enableNumberFieldMode(PrivilegeProviderClient.getValue((String)EnumMailPrivilege.PACKAGE_WITH_COD_MAX_VALUE.toString(), (long)MailConfig.PACKAGE_WITH_COD_MAX_VALUE.getLongValue()));
                    this.enableRemittanceButton.setToggled(false);
                    this.currencyTextField.enable();
                } else {
                    this.selectItemButton.disable();
                    this.currencyTextField.disable();
                }
                this.currencyTextField.setText("0");
            } else if (element == this.enablePackageButton) {
                if (this.enablePackageButton.isToggled()) {
                    this.selectItemButton.enable();
                    if (this.currentItemButton != null) {
                        this.packageAmountTextField.enable();
                    }
                } else {
                    this.selectItemButton.disable();
                    if (this.currentItemButton != null) {
                        this.currentItemButton.setToggled(false);
                    }
                    this.currentItemButton = null;
                    this.packageAmountTextField.disable();
                }
                this.packageAmountTextField.setText("0");
            }
        }
    }

    public void itemSelected(InventoryItemGUIButton clicked) {
        if (this.currentItemButton != clicked) {
            if (this.currentItemButton != null) {
                this.currentItemButton.setToggled(false);
            }
            clicked.toggle();
            this.currentItemButton = clicked;
            int maxAmount = PrivilegeProviderClient.getValue((String)EnumMailPrivilege.PACKAGE_MAX_AMOUNT.toString(), (int)MailConfig.PACKAGE_MAX_AMOUNT.getIntValue());
            ItemStack itemStack = (ItemStack)this.currentItemButton.index;
            if (maxAmount < 0) {
                maxAmount = itemStack.func_77976_d();
            }
            this.packageAmountTextField.enableNumberFieldMode((long)MathUtils.lesserOfTwo((int)this.screen.getEqualStackAmount(clicked.stackWrapper), (int)maxAmount));
            this.packageAmountTextField.setText("1");
            this.packageAmountTextField.enable();
            if (this.enableRemittanceButton.isToggled()) {
                this.enableRemittanceButton.setToggled(false);
                this.currencyTextField.disable();
            }
        }
    }

    public Mail createMessage() {
        EnumMail type = EnumMail.LETTER;
        if (this.enableRemittanceButton.isToggled()) {
            type = EnumMail.REMITTANCE;
        } else if (this.enablePackageButton.isToggled()) {
            type = this.enableCODButton.isToggled() ? EnumMail.PACKAGE_WITH_COD : EnumMail.PACKAGE;
        }
        long currency = 0L;
        if (!this.currencyTextField.getTypedText().isEmpty()) {
            currency = this.currencyTextField.getTypedNumber();
        }
        Parcel parcel = null;
        if (this.currentItemButton != null) {
            parcel = Parcel.create((ItemStack)this.currentItemButton.index, (int)this.packageAmountTextField.getTypedNumber());
        }
        Mail message = new Mail(0L, type, UUID.randomUUID(), ClientReference.getClientPlayer().func_70005_c_(), this.subjectTextField.getTypedText(), this.messageTextBoxField.getTypedText(), currency, parcel);
        return message;
    }

    public void sharedDataSynchronized() {
        this.addresseeTextField.load();
        this.addresseeTextField.enable();
    }

    public void mailSynchronized() {
    }

    public void messageSent(Parcel parcel, long balance) {
        this.balanceElement.setValue(this.screen.getIncomingSection().getBalanceElement().getValue());
        if (parcel != null) {
            this.inventoryLoadElement.setLoad(this.screen.getIncomingSection().getInventoryLoadElement().getLoad());
            ((SelectItemGUICallback)this.selectItemCallback).loadInventoryContent();
        }
        this.addresseeTextField.reset();
        this.subjectTextField.reset();
        this.messageTextBoxField.reset();
        this.enableRemittanceButton.setToggled(false);
        this.enableCODButton.setToggled(false);
        this.enablePackageButton.setToggled(false);
        this.currencyTextField.disable();
        this.currencyTextField.setText("0");
        this.packageAmountTextField.disable();
        this.packageAmountTextField.setText("0");
        if (this.currentItemButton != null) {
            this.currentItemButton.setToggled(false);
        }
        this.currentItemButton = null;
        this.selectItemButton.disable();
        this.sendButton.disable();
    }

    public void messageRemoved(long messageId) {
    }

    public void attachmentReceived(long oldMessageId, Parcel parcel, long balance) {
        this.balanceElement.setValue(this.screen.getIncomingSection().getBalanceElement().getValue());
        if (parcel != null) {
            this.inventoryLoadElement.setLoad(this.screen.getIncomingSection().getInventoryLoadElement().getLoad());
            ((SelectItemGUICallback)this.selectItemCallback).loadInventoryContent();
        }
    }

    public String getAddresseeUsername() {
        return this.addresseeTextField.getTypedText();
    }

    public InventoryLoadGUIElement getInventoryLoadElement() {
        return this.inventoryLoadElement;
    }

    public CurrencyValueGUIElement getBalanceElement() {
        return this.balanceElement;
    }
}

