/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_mail.client.gui.mail.incoming;

import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.gui.IndexedGUIButton;
import austeretony.oxygen_core.client.gui.elements.CustomRectUtils;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_mail.client.MailManagerClient;
import austeretony.oxygen_mail.common.Mail;
import net.minecraft.client.renderer.GlStateManager;

public class MessageGUIButton
extends IndexedGUIButton<Long> {
    private boolean pending;

    public MessageGUIButton(Mail message) {
        super((Object)message.getId());
        this.pending = message.isPending();
        this.setStaticBackgroundColor(GUISettings.get().getStatusElementColor());
        this.setDynamicBackgroundColor(GUISettings.get().getEnabledElementColor(), GUISettings.get().getDisabledElementColor(), GUISettings.get().getHoveredElementColor());
        this.setTextDynamicColor(GUISettings.get().getEnabledTextColor(), GUISettings.get().getDisabledTextColor(), GUISettings.get().getHoveredTextColor());
        this.setDisplayText(message.getLocalizedSubject());
        if (MailManagerClient.instance().getMailboxContainer().isMarkedAsRead(message.getId())) {
            this.read();
        }
    }

    public void read() {
        this.setTextDynamicColor(GUISettings.get().getEnabledTextColorDark(), GUISettings.get().getEnabledTextColorDark(), GUISettings.get().getEnabledTextColorDark());
    }

    public void setPending(boolean flag) {
        this.pending = flag;
    }

    public void draw(int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
        GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int color = this.getEnabledBackgroundColor();
        int textColor = this.getEnabledTextColor();
        int textY = (this.getHeight() - this.textHeight(this.getTextScale())) / 2;
        if (!this.isEnabled()) {
            color = this.getDisabledBackgroundColor();
            textColor = this.getDisabledTextColor();
        } else if (this.isHovered() || this.isToggled()) {
            color = this.getHoveredBackgroundColor();
            textColor = this.getHoveredTextColor();
        }
        int third = this.getWidth() / 3;
        CustomRectUtils.drawGradientRect((double)0.0, (double)0.0, (double)third, (double)this.getHeight(), (int)0, (int)color, (EnumGUIAlignment)EnumGUIAlignment.RIGHT);
        MessageGUIButton.drawRect((int)third, (int)0, (int)(this.getWidth() - third), (int)this.getHeight(), (int)color);
        CustomRectUtils.drawGradientRect((double)(this.getWidth() - third), (double)0.0, (double)this.getWidth(), (double)this.getHeight(), (int)0, (int)color, (EnumGUIAlignment)EnumGUIAlignment.LEFT);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)textY, (float)0.0f);
        GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
        if (this.pending) {
            this.mc.field_71466_p.func_175065_a("!", 0.0f, 0.0f, this.getStaticBackgroundColor(), false);
        }
        this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 6.0f, 0.0f, textColor, false);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }
}

