/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_mail.client.gui.mail.sending.callback;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.gui.elements.OxygenCallbackGUIFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButtonPanel;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_mail.client.gui.mail.MailMenuGUIScreen;
import austeretony.oxygen_mail.client.gui.mail.SendingGUISection;
import austeretony.oxygen_mail.client.gui.mail.sending.InventoryItemGUIButton;
import java.util.HashSet;

public class SelectItemGUICallback
extends AbstractGUICallback {
    private final MailMenuGUIScreen screen;
    private final SendingGUISection section;
    private OxygenGUIButtonPanel inventoryContentPanel;
    private OxygenGUIButton closeButton;

    public SelectItemGUICallback(MailMenuGUIScreen screen, SendingGUISection section, int width, int height) {
        super((AbstractGUIScreen)screen, (AbstractGUISection)section, width, height);
        this.screen = screen;
        this.section = section;
    }

    public void init() {
        this.addElement((GUIBaseElement)new OxygenCallbackGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, ClientReference.localize((String)"oxygen_mail.gui.mail.callback.selectItem", (Object[])new Object[0]), GUISettings.get().getTextScale(), GUISettings.get().getEnabledTextColor()));
        this.inventoryContentPanel = new OxygenGUIButtonPanel((AbstractGUIScreen)this.screen, 6, 15, 128, 16, 1, 36, 4, GUISettings.get().getPanelTextScale(), false);
        this.addElement((GUIBaseElement)this.inventoryContentPanel);
        this.loadInventoryContent();
        this.inventoryContentPanel.setClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> this.section.itemSelected((InventoryItemGUIButton)((Object)clicked)));
        this.closeButton = new OxygenGUIButton(this.getWidth() - 55, this.getHeight() - 12, 40, 10, ClientReference.localize((String)"oxygen.gui.closeButton", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.closeButton);
    }

    public void loadInventoryContent() {
        if (this.inventoryContentPanel != null) {
            this.inventoryContentPanel.reset();
            HashSet<String> added = new HashSet<String>();
            for (ItemStackWrapper stackWrapper : this.screen.inventoryContent.keySet()) {
                String key = SelectItemGUICallback.getKey(stackWrapper);
                if (added.contains(key)) continue;
                this.inventoryContentPanel.addButton((GUIButton)new InventoryItemGUIButton(stackWrapper, this.screen.getEqualStackAmount(stackWrapper)));
                added.add(key);
            }
            this.inventoryContentPanel.getScroller().resetPosition();
            this.inventoryContentPanel.getScroller().getSlider().reset();
            this.inventoryContentPanel.getScroller().updateRowsAmount(MathUtils.clamp((int)this.screen.inventoryContent.size(), (int)9, (int)36));
        }
    }

    private static String getKey(ItemStackWrapper stackWrapper) {
        return String.valueOf(stackWrapper.itemId) + "_" + String.valueOf(stackWrapper.damage) + "_" + stackWrapper.stackNBTStr + "_" + stackWrapper.capNBTStr;
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0 && element == this.closeButton) {
            this.close();
        }
    }
}

