/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_mail.client.gui.mail.sending.callback;

import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.PrivilegeProviderClient;
import austeretony.oxygen_core.client.gui.elements.CurrencyValueGUIElement;
import austeretony.oxygen_core.client.gui.elements.OxygenCallbackGUIFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_mail.client.MailManagerClient;
import austeretony.oxygen_mail.client.gui.mail.MailMenuGUIScreen;
import austeretony.oxygen_mail.client.gui.mail.SendingGUISection;
import austeretony.oxygen_mail.client.gui.mail.incoming.AttachmentGUIElement;
import austeretony.oxygen_mail.common.EnumMail;
import austeretony.oxygen_mail.common.Mail;
import austeretony.oxygen_mail.common.Parcel;
import austeretony.oxygen_mail.common.config.MailConfig;
import austeretony.oxygen_mail.common.main.EnumMailPrivilege;

public class SendMessageGUICallback
extends AbstractGUICallback {
    private final MailMenuGUIScreen screen;
    private final SendingGUISection section;
    private OxygenGUIButton confirmButton;
    private OxygenGUIButton cancelButton;
    private OxygenGUIText messageTypeTextLabel;
    private OxygenGUIText attachmentNoticeTextLabel;
    private OxygenGUIText addresseeTextLabel;
    private OxygenGUIText postageTextLabel;
    private AttachmentGUIElement attachmentElement;
    private CurrencyValueGUIElement postageElement;
    private EnumMail type;
    private String subject;
    private String message;
    private long currency;
    private Parcel parcel;

    public SendMessageGUICallback(MailMenuGUIScreen screen, SendingGUISection section, int width, int height) {
        super((AbstractGUIScreen)screen, (AbstractGUISection)section, width, height);
        this.screen = screen;
        this.section = section;
    }

    public void init() {
        this.addElement((GUIBaseElement)new OxygenCallbackGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, ClientReference.localize((String)"oxygen_mail.gui.mail.callback.sendMessage", (Object[])new Object[0]), GUISettings.get().getTextScale(), GUISettings.get().getEnabledTextColor()));
        this.messageTypeTextLabel = new OxygenGUIText(6, 17, "", GUISettings.get().getTextScale(), GUISettings.get().getEnabledTextColor());
        this.addElement((GUIBaseElement)this.messageTypeTextLabel);
        this.addresseeTextLabel = new OxygenGUIText(6, 26, "", GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark());
        this.addElement((GUIBaseElement)this.addresseeTextLabel);
        this.attachmentNoticeTextLabel = (OxygenGUIText)new OxygenGUIText(6, 35, ClientReference.localize((String)"oxygen_mail.gui.mail.noAttachment", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()).disableFull();
        this.addElement((GUIBaseElement)this.attachmentNoticeTextLabel);
        this.attachmentElement = (AttachmentGUIElement)new AttachmentGUIElement(6, 34).disableFull();
        this.addElement((GUIBaseElement)this.attachmentElement);
        this.postageTextLabel = new OxygenGUIText(6, this.getHeight() - 22, ClientReference.localize((String)"oxygen_mail.gui.mail.postage", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark());
        this.addElement((GUIBaseElement)this.postageTextLabel);
        this.postageElement = new CurrencyValueGUIElement(6, this.getHeight() - 23);
        this.addElement((GUIBaseElement)this.postageElement);
        this.confirmButton = new OxygenGUIButton(15, this.getHeight() - 12, 40, 10, ClientReference.localize((String)"oxygen.gui.confirmButton", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.confirmButton);
        this.cancelButton = new OxygenGUIButton(this.getWidth() - 55, this.getHeight() - 12, 40, 10, ClientReference.localize((String)"oxygen.gui.cancelButton", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.cancelButton);
    }

    public void onOpen() {
        this.attachmentNoticeTextLabel.disableFull();
        this.attachmentElement.disableFull();
        this.confirmButton.enable();
        Mail message = this.section.createMessage();
        this.messageTypeTextLabel.setDisplayText(message.getType().localizedName());
        this.addresseeTextLabel.setDisplayText(ClientReference.localize((String)"oxygen_mail.gui.mail.addressee", (Object[])new Object[]{this.section.getAddresseeUsername()}));
        if (message.getType() == EnumMail.LETTER) {
            this.attachmentNoticeTextLabel.enableFull();
        } else {
            this.attachmentElement.load(message);
            this.attachmentElement.enableFull();
        }
        long postage = 0L;
        long codComission = 0L;
        long remittance = 0L;
        switch (message.getType()) {
            case LETTER: {
                long value;
                if (message.getMessage().isEmpty()) {
                    this.confirmButton.disable();
                }
                postage = value = PrivilegeProviderClient.getValue((String)EnumMailPrivilege.LETTER_POSTAGE_VALUE.toString(), (long)MailConfig.LETTER_POSTAGE_VALUE.getLongValue());
                break;
            }
            case REMITTANCE: {
                if (message.getCurrency() <= 0L) {
                    this.confirmButton.disable();
                }
                long percent = PrivilegeProviderClient.getValue((String)EnumMailPrivilege.REMITTANCE_POSTAGE_PERCENT.toString(), (int)MailConfig.REMITTANCE_POSTAGE_PERCENT.getIntValue());
                remittance = message.getCurrency();
                postage = MathUtils.percentValueOf((long)message.getCurrency(), (int)((int)percent));
                break;
            }
            case PACKAGE: {
                long value;
                if (message.getParcel() == null) {
                    this.confirmButton.disable();
                }
                if (message.getParcel().amount <= 0) {
                    this.confirmButton.disable();
                }
                postage = value = PrivilegeProviderClient.getValue((String)EnumMailPrivilege.PACKAGE_POSTAGE_VALUE.toString(), (long)MailConfig.PACKAGE_POSTAGE_VALUE.getLongValue());
                break;
            }
            case PACKAGE_WITH_COD: {
                if (message.getCurrency() <= 0L || message.getParcel() == null) {
                    this.confirmButton.disable();
                }
                if (message.getParcel().amount <= 0) {
                    this.confirmButton.disable();
                }
                long value = PrivilegeProviderClient.getValue((String)EnumMailPrivilege.PACKAGE_POSTAGE_VALUE.toString(), (long)MailConfig.PACKAGE_POSTAGE_VALUE.getLongValue());
                long percent = PrivilegeProviderClient.getValue((String)EnumMailPrivilege.PACKAGE_WITH_COD_POSTAGE_PERCENT.toString(), (int)MailConfig.PACKAGE_WITH_COD_POSTAGE_PERCENT.getIntValue());
                codComission = MathUtils.percentValueOf((long)message.getCurrency(), (int)((int)percent));
                postage = value;
                break;
            }
        }
        this.postageElement.setValue(postage + codComission);
        if (remittance + postage > this.section.getBalanceElement().getValue()) {
            this.postageElement.setRed(true);
            this.confirmButton.disable();
        }
        this.postageElement.setX(this.postageTextLabel.getX() + 4 + this.textWidth(this.postageTextLabel.getDisplayText(), GUISettings.get().getSubTextScale()) + this.textWidth(this.postageElement.getDisplayText(), GUISettings.get().getSubTextScale()));
        this.type = message.getType();
        this.subject = message.getSubject();
        this.message = message.getMessage();
        this.currency = message.getCurrency();
        this.parcel = message.getParcel();
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0) {
            if (element == this.cancelButton) {
                this.close();
            } else if (element == this.confirmButton) {
                MailManagerClient.instance().getMailboxManager().sendMessageSynced(this.type, this.section.getAddresseeUsername(), this.subject, this.message, this.currency, this.parcel);
                this.close();
            }
        }
    }
}

