/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_mail.common;

import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.common.persistent.PersistentEntry;
import austeretony.oxygen_core.common.sync.SynchronizedData;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_mail.common.EnumMail;
import austeretony.oxygen_mail.common.Parcel;
import austeretony.oxygen_mail.common.config.MailConfig;
import io.netty.buffer.ByteBuf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class Mail
implements PersistentEntry,
SynchronizedData {
    public static final int MESSAGE_SUBJECT_MAX_LENGTH = 24;
    public static final int MESSAGE_MAX_LENGTH = 800;
    public static final UUID SYSTEM_UUID = UUID.fromString("d10d07f6-ae3c-4ec6-a055-1160c4cf848a");
    private long messageId;
    private EnumMail type;
    private UUID senderUUID;
    private String senderName;
    private String subject;
    private String message;
    private long currency;
    private Parcel parcel;
    private boolean pending;

    public Mail() {
    }

    public Mail(long messageId, EnumMail type, UUID senderUUID, String senderName, String subject, String message, long currency, Parcel parcel) {
        this.messageId = messageId;
        this.type = type;
        this.senderUUID = senderUUID;
        this.senderName = senderName;
        if (subject.length() > 24) {
            subject = subject.substring(0, 24);
        }
        this.subject = subject;
        if (message.length() > 800) {
            message = message.substring(0, 800);
        }
        this.message = message;
        this.currency = currency;
        this.parcel = parcel;
        if (currency > 0L || parcel != null) {
            this.pending = true;
        }
    }

    public long getId() {
        return this.messageId;
    }

    public void setId(long messageId) {
        this.messageId = messageId;
    }

    public EnumMail getType() {
        return this.type;
    }

    public UUID getSenderUUID() {
        return this.senderUUID;
    }

    public String getSenderUsername() {
        return this.senderName;
    }

    public String getLocalizedSenderName() {
        return ClientReference.localize((String)this.senderName, (Object[])new Object[0]);
    }

    public String getSubject() {
        return this.subject;
    }

    public String getLocalizedSubject() {
        return ClientReference.localize((String)this.subject, (Object[])new Object[0]);
    }

    public String getMessage() {
        return this.message;
    }

    public String getLocalizedMessage() {
        return ClientReference.localize((String)this.message, (Object[])new Object[0]);
    }

    public long getCurrency() {
        return this.currency;
    }

    public Parcel getParcel() {
        return this.parcel;
    }

    public boolean isPending() {
        return this.pending;
    }

    public void setPending(boolean flag) {
        this.pending = flag;
        if (!flag) {
            this.currency = 0L;
            this.parcel = null;
        }
    }

    public boolean isExpired() {
        int expiresInHours = -1;
        switch (this.type) {
            case SYSTEM_LETTER: {
                expiresInHours = MailConfig.SYSTEM_LETTER_EXPIRE_TIME_HOURS.getIntValue();
                break;
            }
            case LETTER: {
                expiresInHours = MailConfig.LETTER_EXPIRE_TIME_HOURS.getIntValue();
                break;
            }
            case SYSTEM_REMITTANCE: {
                expiresInHours = MailConfig.SYSTEM_REMITTANCE_EXPIRE_TIME_HOURS.getIntValue();
                break;
            }
            case REMITTANCE: {
                expiresInHours = MailConfig.REMITTANCE_EXPIRE_TIME_HOURS.getIntValue();
                break;
            }
            case SYSTEM_PACKAGE: {
                expiresInHours = MailConfig.SYSTEM_PACKAGE_EXPIRE_TIME_HOURS.getIntValue();
                break;
            }
            case PACKAGE: {
                expiresInHours = MailConfig.PACKAGE_EXPIRE_TIME_HOURS.getIntValue();
                break;
            }
            case PACKAGE_WITH_COD: {
                expiresInHours = MailConfig.PACKAGE_WITH_COD_EXPIRE_TIME_HOURS.getIntValue();
            }
        }
        if (expiresInHours < 0) {
            return false;
        }
        return System.currentTimeMillis() - this.messageId > (long)expiresInHours * 3600000L;
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((long)this.messageId, (OutputStream)bos);
        StreamUtils.write((byte)((byte)this.type.ordinal()), (OutputStream)bos);
        StreamUtils.write((UUID)this.senderUUID, (OutputStream)bos);
        StreamUtils.write((String)this.senderName, (OutputStream)bos);
        StreamUtils.write((String)this.subject, (OutputStream)bos);
        StreamUtils.write((String)this.message, (OutputStream)bos);
        StreamUtils.write((long)this.currency, (OutputStream)bos);
        StreamUtils.write((this.parcel != null ? 1 : 0) != 0, (OutputStream)bos);
        if (this.parcel != null) {
            this.parcel.write(bos);
        }
        StreamUtils.write((boolean)this.pending, (OutputStream)bos);
    }

    public void read(BufferedInputStream bis) throws IOException {
        this.messageId = StreamUtils.readLong((InputStream)bis);
        this.type = EnumMail.values()[bis.read()];
        this.senderUUID = StreamUtils.readUUID((InputStream)bis);
        this.senderName = StreamUtils.readString((InputStream)bis);
        this.subject = StreamUtils.readString((InputStream)bis);
        this.message = StreamUtils.readString((InputStream)bis);
        this.currency = StreamUtils.readLong((InputStream)bis);
        if (StreamUtils.readBoolean((InputStream)bis)) {
            this.parcel = Parcel.read(bis);
        }
        this.pending = StreamUtils.readBoolean((InputStream)bis);
    }

    public void write(ByteBuf buffer) {
        buffer.writeLong(this.messageId);
        buffer.writeByte(this.type.ordinal());
        ByteBufUtils.writeUUID((UUID)this.senderUUID, (ByteBuf)buffer);
        ByteBufUtils.writeString((String)this.senderName, (ByteBuf)buffer);
        ByteBufUtils.writeString((String)this.subject, (ByteBuf)buffer);
        ByteBufUtils.writeString((String)this.message, (ByteBuf)buffer);
        buffer.writeLong(this.currency);
        buffer.writeBoolean(this.parcel != null);
        if (this.parcel != null) {
            this.parcel.write(buffer);
        }
        buffer.writeBoolean(this.pending);
    }

    public void read(ByteBuf buffer) {
        this.messageId = buffer.readLong();
        this.type = EnumMail.values()[buffer.readByte()];
        this.senderUUID = ByteBufUtils.readUUID((ByteBuf)buffer);
        this.senderName = ByteBufUtils.readString((ByteBuf)buffer);
        this.subject = ByteBufUtils.readString((ByteBuf)buffer);
        this.message = ByteBufUtils.readString((ByteBuf)buffer);
        this.currency = buffer.readLong();
        if (buffer.readBoolean()) {
            this.parcel = Parcel.read(buffer);
        }
        this.pending = buffer.readBoolean();
    }
}

