/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_mail.common.network.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.RequestsFilterHelper;
import austeretony.oxygen_mail.common.EnumMail;
import austeretony.oxygen_mail.common.Parcel;
import austeretony.oxygen_mail.server.MailManagerServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;

public class SPSendMessage
extends Packet {
    private String addressee;
    private String subject;
    private String message;
    private int ordinal;
    private long currency;
    private Parcel parcel;

    public SPSendMessage() {
    }

    public SPSendMessage(EnumMail type, String addressee, String subject, String message, long currency, Parcel parcel) {
        this.ordinal = type.ordinal();
        this.addressee = addressee;
        this.subject = subject;
        this.message = message;
        this.currency = currency;
        this.parcel = parcel;
    }

    public void write(ByteBuf buffer, INetHandler netHandler) {
        ByteBufUtils.writeString((String)this.addressee, (ByteBuf)buffer);
        ByteBufUtils.writeString((String)this.subject, (ByteBuf)buffer);
        ByteBufUtils.writeString((String)this.message, (ByteBuf)buffer);
        buffer.writeByte(this.ordinal);
        buffer.writeLong(this.currency);
        buffer.writeBoolean(this.parcel != null);
        if (this.parcel != null) {
            this.parcel.write(buffer);
        }
    }

    public void read(ByteBuf buffer, INetHandler netHandler) {
        EntityPlayerMP playerMP = SPSendMessage.getEntityPlayerMP((INetHandler)netHandler);
        if (RequestsFilterHelper.getLock((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (int)85)) {
            Parcel parcel;
            String addressee = ByteBufUtils.readString((ByteBuf)buffer);
            String subject = ByteBufUtils.readString((ByteBuf)buffer);
            String message = ByteBufUtils.readString((ByteBuf)buffer);
            byte ordinal = buffer.readByte();
            long currency = buffer.readLong();
            Parcel parcel2 = parcel = buffer.readBoolean() ? Parcel.read(buffer) : null;
            if (ordinal >= 0 && ordinal < EnumMail.values().length) {
                OxygenHelperServer.addRoutineTask(() -> MailManagerServer.instance().getMailboxesManager().sendMail(playerMP, EnumMail.values()[ordinal], addressee, subject, message, currency, parcel));
            }
        }
    }
}

