/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_mail.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.persistent.PersistentData;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.item.ItemsBlackList;
import austeretony.oxygen_mail.server.MailboxesContainerServer;
import austeretony.oxygen_mail.server.MailboxesManagerServer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public final class MailManagerServer {
    private static MailManagerServer instance;
    private final MailboxesContainerServer mailboxesContainer = new MailboxesContainerServer();
    private final MailboxesManagerServer mailboxesManager;
    private final ItemsBlackList itemsBlackList = ItemsBlackList.create((String)"mail");

    private MailManagerServer() {
        this.mailboxesManager = new MailboxesManagerServer(this);
        OxygenHelperServer.registerPersistentData((PersistentData)this.mailboxesContainer);
    }

    public static void create() {
        if (instance == null) {
            instance = new MailManagerServer();
        }
    }

    public static MailManagerServer instance() {
        return instance;
    }

    public MailboxesContainerServer getMailboxesContainer() {
        return this.mailboxesContainer;
    }

    public MailboxesManagerServer getMailboxesManager() {
        return this.mailboxesManager;
    }

    public ItemsBlackList getItemsBlackList() {
        return this.itemsBlackList;
    }

    public void worldLoaded() {
        OxygenHelperServer.loadPersistentDataAsync((PersistentData)this.mailboxesContainer);
    }

    public void playerLoggedIn(EntityPlayerMP playerMP) {
        this.mailboxesManager.checkMailbox(CommonReference.getPersistentUUID((Entity)playerMP));
    }
}

