/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_mail.server;

import austeretony.oxygen_core.common.persistent.AbstractPersistentData;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_mail.common.config.MailConfig;
import austeretony.oxygen_mail.common.main.MailMain;
import austeretony.oxygen_mail.server.MailManagerServer;
import austeretony.oxygen_mail.server.Mailbox;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class MailboxesContainerServer
extends AbstractPersistentData {
    private final Map<UUID, Mailbox> mailboxes = new ConcurrentHashMap<UUID, Mailbox>();

    public int getMailboxesAmount() {
        return this.mailboxes.size();
    }

    public Collection<Mailbox> getMailboxes() {
        return this.mailboxes.values();
    }

    public boolean isMailboxExist(UUID playerUUID) {
        return this.mailboxes.containsKey(playerUUID);
    }

    public void createMailboxForPlayer(UUID playerUUID) {
        this.mailboxes.put(playerUUID, new Mailbox(playerUUID));
    }

    public Mailbox getPlayerMailbox(UUID playerUUID) {
        return this.mailboxes.get(playerUUID);
    }

    public String getDisplayName() {
        return "mailboxes";
    }

    public String getPath() {
        return OxygenHelperServer.getDataFolder() + "/server/world/mail/mailboxes.dat";
    }

    public long getSaveDelayMinutes() {
        return MailConfig.MAIL_SAVE_DELAY_MINUTES.getIntValue();
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((int)this.mailboxes.size(), (OutputStream)bos);
        for (Mailbox mailbox : this.mailboxes.values()) {
            mailbox.write(bos);
        }
    }

    public void read(BufferedInputStream bis) throws IOException {
        int amount = StreamUtils.readInt((InputStream)bis);
        for (int i = 0; i < amount; ++i) {
            Mailbox mailbox = Mailbox.read(bis);
            this.mailboxes.put(mailbox.playerUUID, mailbox);
        }
        MailMain.LOGGER.info("Loaded {} mailboxes.", (Object)amount);
        MailManagerServer.instance().getMailboxesManager().processExpiredMail();
    }

    public void reset() {
        this.mailboxes.clear();
    }
}

