/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_mail.server;

import austeretony.oxygen_core.common.PlayerSharedData;
import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.api.notification.SimpleNotification;
import austeretony.oxygen_core.common.currency.CurrencyHelperServer;
import austeretony.oxygen_core.common.inventory.InventoryHelper;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.notification.Notification;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_core.server.OxygenManagerServer;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.PrivilegeProviderServer;
import austeretony.oxygen_core.server.api.SoundEventHelperServer;
import austeretony.oxygen_core.server.api.WatcherHelperServer;
import austeretony.oxygen_mail.common.EnumMail;
import austeretony.oxygen_mail.common.EnumMessageOperation;
import austeretony.oxygen_mail.common.Mail;
import austeretony.oxygen_mail.common.Parcel;
import austeretony.oxygen_mail.common.config.MailConfig;
import austeretony.oxygen_mail.common.main.EnumMailPrivilege;
import austeretony.oxygen_mail.common.main.EnumMailStatusMessage;
import austeretony.oxygen_mail.common.main.MailMain;
import austeretony.oxygen_mail.common.network.client.CPAttachmentReceived;
import austeretony.oxygen_mail.common.network.client.CPMessageRemoved;
import austeretony.oxygen_mail.common.network.client.CPMessageSent;
import austeretony.oxygen_mail.server.MailManagerServer;
import austeretony.oxygen_mail.server.Mailbox;
import austeretony.oxygen_mail.server.QueuedMailOperation;
import austeretony.oxygen_mail.server.QueuedMailSending;
import java.util.Iterator;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MailboxesManagerServer {
    private final MailManagerServer manager;
    private final Queue<QueuedMailSending> mailSendingQueue = new ConcurrentLinkedQueue<QueuedMailSending>();
    private final Queue<QueuedMailOperation> mailOperationsQueue = new ConcurrentLinkedQueue<QueuedMailOperation>();

    public MailboxesManagerServer(MailManagerServer manager) {
        this.manager = manager;
        OxygenManagerServer.instance().getExecutionManager().getExecutors().getSchedulerExecutorService().scheduleAtFixedRate(() -> {
            this.processMailSendingQueue();
            this.processMailOperationsQueue();
        }, 1000L, 250L, TimeUnit.MILLISECONDS);
    }

    public void processExpiredMail() {
        int removed = 0;
        for (Mailbox mailbox : this.manager.getMailboxesContainer().getMailboxes()) {
            Iterator<Mail> iterator = mailbox.getMessages().iterator();
            while (iterator.hasNext()) {
                Mail mail = iterator.next();
                if (!mail.isExpired()) continue;
                if (mail.isPending()) {
                    this.processExpiredMessage(mail);
                }
                iterator.remove();
                ++removed;
            }
        }
        if (removed > 0) {
            this.manager.getMailboxesContainer().setChanged(true);
        }
        MailMain.LOGGER.info("Expired mail processed. Removed {} messages in total", (Object)removed);
    }

    private void processExpiredMessage(Mail message) {
        if (message.getType() == EnumMail.REMITTANCE || message.getType() == EnumMail.PACKAGE || message.getType() == EnumMail.PACKAGE_WITH_COD) {
            if (message.getType() == EnumMail.REMITTANCE) {
                this.sendSystemRemittance(message.getSenderUUID(), "mail.sender.sys", "mail.subject.return", "mail.message.remittanceReturn", message.getCurrency());
            }
            if (message.getType() == EnumMail.PACKAGE || message.getType() == EnumMail.PACKAGE_WITH_COD) {
                this.sendSystemPackage(message.getSenderUUID(), "mail.sender.sys", "mail.subject.return", "mail.message.packageReturn", message.getParcel());
            }
        }
    }

    private void sendNewMessageNotification(UUID playerUUID) {
        if (OxygenHelperServer.isPlayerOnline((UUID)playerUUID)) {
            OxygenHelperServer.addNotification((EntityPlayerMP)CommonReference.playerByUUID((UUID)playerUUID), (Notification)new SimpleNotification(80, "oxygen_mail.incoming", new String[0]));
        }
    }

    public void informPlayer(EntityPlayerMP playerMP, EnumMailStatusMessage status) {
        OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)8, (int)status.ordinal());
    }

    public void sendMail(EntityPlayerMP senderMP, EnumMail type, String addressee, String subject, String message, long currency, Parcel parcel) {
        this.mailSendingQueue.offer(new QueuedMailSending(CommonReference.getPersistentUUID((Entity)senderMP), type, addressee, subject, message, currency, parcel));
    }

    private void processMailSendingQueue() {
        while (!this.mailSendingQueue.isEmpty()) {
            QueuedMailSending queued = this.mailSendingQueue.poll();
            EntityPlayerMP senderMP = CommonReference.playerByUUID((UUID)queued.playerUUID);
            if (senderMP == null) continue;
            OxygenHelperServer.addRoutineTask(() -> this.sendMailQueue(senderMP, queued.type, queued.addressee, queued.subject, queued.message, queued.currency, queued.parcel));
        }
    }

    private void sendMailQueue(EntityPlayerMP senderMP, EnumMail type, String addressee, String subject, String message, long currency, Parcel parcel) {
        PlayerSharedData sharedData = OxygenHelperServer.getPlayerSharedData((String)addressee);
        if (sharedData == null) {
            this.informPlayer(senderMP, EnumMailStatusMessage.PLAYER_NOT_FOUND);
            return;
        }
        if (this.processPlayerMailSending(senderMP, type, sharedData.getPlayerUUID(), subject, message, currency, parcel, false)) {
            this.informPlayer(senderMP, EnumMailStatusMessage.MESSAGE_SENT);
        } else {
            this.informPlayer(senderMP, EnumMailStatusMessage.MESSAGE_SENDING_FAILED);
        }
    }

    private boolean processPlayerMailSending(EntityPlayerMP senderMP, EnumMail type, UUID addresseeUUID, String subject, String message, long currency, Parcel parcel, boolean isReturn) {
        Mailbox targetMailbox;
        Mailbox senderMailbox;
        if (subject.isEmpty()) {
            return false;
        }
        UUID senderUUID = CommonReference.getPersistentUUID((Entity)senderMP);
        this.checkMailbox(senderUUID);
        this.checkMailbox(addresseeUUID);
        if (!addresseeUUID.equals(senderUUID) && (senderMailbox = this.manager.getMailboxesContainer().getPlayerMailbox(senderUUID)).canSendMessage() && (targetMailbox = this.manager.getMailboxesContainer().getPlayerMailbox(addresseeUUID)).canAcceptMessages()) {
            switch (type) {
                case LETTER: {
                    currency = 0L;
                    parcel = null;
                    if (!message.isEmpty() && this.processLetter(senderMP, senderUUID)) break;
                    return false;
                }
                case REMITTANCE: {
                    if (currency <= 0L) {
                        return false;
                    }
                    parcel = null;
                    if (isReturn || this.processRemittance(senderMP, senderUUID, currency)) break;
                    return false;
                }
                case PACKAGE: {
                    if (parcel == null) {
                        return false;
                    }
                    if (!this.validateParcel(senderMP, parcel)) {
                        return false;
                    }
                    currency = 0L;
                    if (isReturn || this.processPackage(senderMP, senderUUID, parcel)) break;
                    return false;
                }
                case PACKAGE_WITH_COD: {
                    if (currency <= 0L || parcel == null) {
                        return false;
                    }
                    if (!this.validateParcel(senderMP, parcel)) {
                        return false;
                    }
                    if (isReturn || this.processPackageWithCOD(senderMP, senderUUID, currency, parcel)) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            senderMailbox.updateLastMessageSendingTime();
            this.addMessage(targetMailbox, type, senderUUID, CommonReference.getName((Entity)senderMP), subject, message, parcel, currency);
            OxygenMain.network().sendTo((Packet)new CPMessageSent(parcel, CurrencyHelperServer.getCurrency((UUID)senderUUID)), senderMP);
            return true;
        }
        return false;
    }

    private boolean validateParcel(EntityPlayerMP playerMP, Parcel parcel) {
        if (parcel.stackWrapper.itemId == Item.func_150891_b((Item)Items.field_190931_a) || parcel.amount <= 0) {
            this.informPlayer(playerMP, EnumMailStatusMessage.PARCEL_DAMAGED);
            return false;
        }
        if (this.manager.getItemsBlackList().isBlackListed(Item.func_150899_d((int)parcel.stackWrapper.itemId))) {
            this.informPlayer(playerMP, EnumMailStatusMessage.ITEM_BLACKLISTED);
            return false;
        }
        return true;
    }

    public void checkMailbox(UUID playerUUID) {
        if (!this.manager.getMailboxesContainer().isMailboxExist(playerUUID)) {
            this.manager.getMailboxesContainer().createMailboxForPlayer(playerUUID);
        }
    }

    private void addMessage(Mailbox targetMailbox, EnumMail type, UUID senderUUID, String senderName, String subject, String message, Parcel parcel, long currency) {
        targetMailbox.addMessage(new Mail(targetMailbox.getNewId(System.currentTimeMillis()), type, senderUUID, senderName, subject, message, currency, parcel));
        this.sendNewMessageNotification(targetMailbox.playerUUID);
        this.manager.getMailboxesContainer().setChanged(true);
    }

    private boolean processLetter(EntityPlayerMP senderMP, UUID senderUUID) {
        boolean postageExist;
        long letterPostage = PrivilegeProviderServer.getValue((UUID)senderUUID, (String)EnumMailPrivilege.LETTER_POSTAGE_VALUE.toString(), (long)MailConfig.LETTER_POSTAGE_VALUE.getLongValue());
        boolean bl = postageExist = letterPostage > 0L;
        if (!postageExist || CurrencyHelperServer.enoughCurrency((UUID)senderUUID, (long)letterPostage)) {
            if (postageExist) {
                CurrencyHelperServer.removeCurrency((UUID)senderUUID, (long)letterPostage);
                WatcherHelperServer.setValue((UUID)senderUUID, (int)0, (long)CurrencyHelperServer.getCurrency((UUID)senderUUID));
                CurrencyHelperServer.save((UUID)senderUUID);
                SoundEventHelperServer.playSoundClient((EntityPlayerMP)senderMP, (int)OxygenSoundEffects.SELL.id);
            }
            return true;
        }
        return false;
    }

    private boolean processRemittance(EntityPlayerMP senderMP, UUID senderUUID, long remittanceValue) {
        long remittancePostage;
        if (remittanceValue <= PrivilegeProviderServer.getValue((UUID)senderUUID, (String)EnumMailPrivilege.REMITTANCE_MAX_VALUE.toString(), (long)MailConfig.REMITTANCE_MAX_VALUE.getLongValue()) && CurrencyHelperServer.enoughCurrency((UUID)senderUUID, (long)(remittanceValue + (remittancePostage = MathUtils.percentValueOf((long)remittanceValue, (int)PrivilegeProviderServer.getValue((UUID)senderUUID, (String)EnumMailPrivilege.REMITTANCE_POSTAGE_PERCENT.toString(), (int)MailConfig.REMITTANCE_POSTAGE_PERCENT.getIntValue())))))) {
            CurrencyHelperServer.removeCurrency((UUID)senderUUID, (long)(remittanceValue + remittancePostage));
            WatcherHelperServer.setValue((UUID)senderUUID, (int)0, (long)CurrencyHelperServer.getCurrency((UUID)senderUUID));
            CurrencyHelperServer.save((UUID)senderUUID);
            SoundEventHelperServer.playSoundClient((EntityPlayerMP)senderMP, (int)OxygenSoundEffects.SELL.id);
            return true;
        }
        return false;
    }

    private boolean processPackage(EntityPlayerMP senderMP, UUID senderUUID, Parcel parcel) {
        int maxAmount = PrivilegeProviderServer.getValue((UUID)senderUUID, (String)EnumMailPrivilege.PACKAGE_MAX_AMOUNT.toString(), (int)MailConfig.PACKAGE_MAX_AMOUNT.getIntValue());
        ItemStack itemStack = parcel.stackWrapper.getItemStack();
        if (maxAmount < 0) {
            maxAmount = itemStack.func_77976_d();
        }
        if (parcel.amount <= maxAmount) {
            boolean postageExist;
            long packagePostage = PrivilegeProviderServer.getValue((UUID)senderUUID, (String)EnumMailPrivilege.PACKAGE_POSTAGE_VALUE.toString(), (long)MailConfig.PACKAGE_POSTAGE_VALUE.getLongValue());
            boolean bl = postageExist = packagePostage > 0L;
            if (InventoryHelper.getEqualStackAmount((EntityPlayer)senderMP, (ItemStack)itemStack) >= parcel.amount && (!postageExist || CurrencyHelperServer.enoughCurrency((UUID)senderUUID, (long)packagePostage))) {
                int amount = parcel.amount;
                CommonReference.delegateToServerThread(() -> InventoryHelper.removeEqualStack((EntityPlayer)senderMP, (ItemStack)itemStack, (int)amount));
                if (postageExist) {
                    CurrencyHelperServer.removeCurrency((UUID)senderUUID, (long)packagePostage);
                    WatcherHelperServer.setValue((UUID)senderUUID, (int)0, (long)CurrencyHelperServer.getCurrency((UUID)senderUUID));
                    CurrencyHelperServer.save((UUID)senderUUID);
                    SoundEventHelperServer.playSoundClient((EntityPlayerMP)senderMP, (int)OxygenSoundEffects.SELL.id);
                }
                return true;
            }
        }
        return false;
    }

    private boolean processPackageWithCOD(EntityPlayerMP senderMP, UUID senderUUID, long currency, Parcel parcel) {
        if (currency <= PrivilegeProviderServer.getValue((UUID)senderUUID, (String)EnumMailPrivilege.PACKAGE_WITH_COD_MAX_VALUE.toString(), (long)MailConfig.PACKAGE_WITH_COD_MAX_VALUE.getLongValue())) {
            int maxAmount = PrivilegeProviderServer.getValue((UUID)senderUUID, (String)EnumMailPrivilege.PACKAGE_MAX_AMOUNT.toString(), (int)MailConfig.PACKAGE_MAX_AMOUNT.getIntValue());
            ItemStack itemStack = parcel.stackWrapper.getItemStack();
            if (maxAmount < 0) {
                maxAmount = itemStack.func_77976_d();
            }
            if (parcel.amount <= maxAmount) {
                boolean postageExist;
                long packagePostage = PrivilegeProviderServer.getValue((UUID)senderUUID, (String)EnumMailPrivilege.PACKAGE_POSTAGE_VALUE.toString(), (long)MailConfig.PACKAGE_POSTAGE_VALUE.getLongValue());
                boolean bl = postageExist = packagePostage > 0L;
                if (InventoryHelper.getEqualStackAmount((EntityPlayer)senderMP, (ItemStack)itemStack) >= parcel.amount && (!postageExist || CurrencyHelperServer.enoughCurrency((UUID)senderUUID, (long)packagePostage))) {
                    int amount = parcel.amount;
                    CommonReference.delegateToServerThread(() -> InventoryHelper.removeEqualStack((EntityPlayer)senderMP, (ItemStack)itemStack, (int)amount));
                    if (postageExist) {
                        CurrencyHelperServer.removeCurrency((UUID)senderUUID, (long)packagePostage);
                        WatcherHelperServer.setValue((UUID)senderUUID, (int)0, (long)CurrencyHelperServer.getCurrency((UUID)senderUUID));
                        CurrencyHelperServer.save((UUID)senderUUID);
                        SoundEventHelperServer.playSoundClient((EntityPlayerMP)senderMP, (int)OxygenSoundEffects.SELL.id);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void processMessageOperation(EntityPlayerMP playerMP, long messageId, EnumMessageOperation operation) {
        this.mailOperationsQueue.offer(new QueuedMailOperation(CommonReference.getPersistentUUID((Entity)playerMP), messageId, operation));
    }

    private void processMailOperationsQueue() {
        while (!this.mailOperationsQueue.isEmpty()) {
            QueuedMailOperation queued = this.mailOperationsQueue.poll();
            EntityPlayerMP senderMP = CommonReference.playerByUUID((UUID)queued.playerUUID);
            if (senderMP == null) continue;
            OxygenHelperServer.addRoutineTask(() -> this.processMessageOperationQueue(senderMP, queued.messageId, queued.operation));
        }
    }

    private void processMessageOperationQueue(EntityPlayerMP playerMP, long messageId, EnumMessageOperation operation) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        Mailbox mailbox = this.manager.getMailboxesContainer().getPlayerMailbox(playerUUID);
        if (mailbox.messageExist(messageId)) {
            Mail message = mailbox.getMessage(messageId);
            switch (operation) {
                case TAKE_ATTACHMENT: {
                    if (!message.isPending() || !this.takeAttachment(playerMP, playerUUID, message)) break;
                    Parcel parcel = message.getParcel();
                    mailbox.removeMessage(messageId);
                    message.setId(mailbox.getNewId(messageId));
                    message.setPending(false);
                    mailbox.addMessage(message);
                    this.manager.getMailboxesContainer().setChanged(true);
                    OxygenMain.network().sendTo((Packet)new CPAttachmentReceived(messageId, parcel, CurrencyHelperServer.getCurrency((UUID)playerUUID)), playerMP);
                    this.informPlayer(playerMP, EnumMailStatusMessage.ATTACHMENT_RECEIVED);
                    break;
                }
                case RETURN: {
                    if (!message.isPending() || !this.returnAttachmentToSender(playerMP, message)) break;
                    mailbox.removeMessage(messageId);
                    this.manager.getMailboxesContainer().setChanged(true);
                    OxygenMain.network().sendTo((Packet)new CPMessageRemoved(messageId), playerMP);
                    this.informPlayer(playerMP, EnumMailStatusMessage.MESSAGE_RETURNED);
                    break;
                }
                case REMOVE_MESSAGE: {
                    if (message.isPending()) break;
                    mailbox.removeMessage(messageId);
                    this.manager.getMailboxesContainer().setChanged(true);
                    OxygenMain.network().sendTo((Packet)new CPMessageRemoved(messageId), playerMP);
                    this.informPlayer(playerMP, EnumMailStatusMessage.MESSAGE_REMOVED);
                }
            }
        }
    }

    private boolean takeAttachment(EntityPlayerMP playerMP, UUID playerUUID, Mail message) {
        if (message.getType() == EnumMail.PACKAGE || message.getType() == EnumMail.SYSTEM_PACKAGE || message.getType() == EnumMail.PACKAGE_WITH_COD) {
            ItemStack itemStack = message.getParcel().stackWrapper.getItemStack();
            if (!InventoryHelper.haveEnoughSpace((EntityPlayer)playerMP, (int)message.getParcel().amount, (int)itemStack.func_77976_d())) {
                return false;
            }
            if (message.getType() == EnumMail.PACKAGE_WITH_COD) {
                if (!CurrencyHelperServer.enoughCurrency((UUID)playerUUID, (long)message.getCurrency())) {
                    return false;
                }
                CurrencyHelperServer.removeCurrency((UUID)playerUUID, (long)message.getCurrency());
                WatcherHelperServer.setValue((UUID)playerUUID, (int)0, (long)CurrencyHelperServer.getCurrency((UUID)playerUUID));
                CurrencyHelperServer.save((UUID)playerUUID);
                long codPostage = MathUtils.percentValueOf((long)message.getCurrency(), (int)PrivilegeProviderServer.getValue((UUID)OxygenHelperServer.getPlayerUUID((String)message.getSenderUsername()), (String)EnumMailPrivilege.PACKAGE_WITH_COD_POSTAGE_PERCENT.toString(), (int)MailConfig.PACKAGE_WITH_COD_POSTAGE_PERCENT.getIntValue()));
                this.sendSystemRemittance(OxygenHelperServer.getPlayerUUID((String)message.getSenderUsername()), CommonReference.getName((Entity)playerMP), "mail.cod.pay.s", "mail.cod.pay.m", message.getCurrency() - codPostage);
            }
            int amount = message.getParcel().amount;
            CommonReference.delegateToServerThread(() -> InventoryHelper.addItemStack((EntityPlayer)playerMP, (ItemStack)itemStack, (int)amount));
            SoundEventHelperServer.playSoundClient((EntityPlayerMP)playerMP, (int)OxygenSoundEffects.INVENTORY.id);
            return true;
        }
        if (message.getType() == EnumMail.REMITTANCE || message.getType() == EnumMail.SYSTEM_REMITTANCE) {
            CurrencyHelperServer.addCurrency((UUID)playerUUID, (long)message.getCurrency());
            WatcherHelperServer.setValue((UUID)playerUUID, (int)0, (long)CurrencyHelperServer.getCurrency((UUID)playerUUID));
            CurrencyHelperServer.save((UUID)playerUUID);
            SoundEventHelperServer.playSoundClient((EntityPlayerMP)playerMP, (int)OxygenSoundEffects.SELL.id);
            return true;
        }
        return false;
    }

    private boolean returnAttachmentToSender(EntityPlayerMP playerMP, Mail message) {
        if (!(message.getType() != EnumMail.REMITTANCE && message.getType() != EnumMail.PACKAGE && message.getType() != EnumMail.PACKAGE_WITH_COD || OxygenHelperServer.getPlayerUUID((String)message.getSenderUsername()) == null || message.getSenderUsername().equals(CommonReference.getName((Entity)playerMP)))) {
            EnumMail type = message.getType();
            if (message.getType() == EnumMail.PACKAGE_WITH_COD) {
                type = EnumMail.PACKAGE;
            }
            if (this.processPlayerMailSending(playerMP, type, message.getSenderUUID(), "mail.subject.return", message.getMessage(), message.getCurrency(), message.getParcel(), true)) {
                return true;
            }
        }
        return false;
    }

    public void sendSystemLetter(UUID addresseeUUID, String senderName, String subject, String message) {
        this.checkMailbox(addresseeUUID);
        Mailbox mailbox = this.manager.getMailboxesContainer().getPlayerMailbox(addresseeUUID);
        this.addMessage(mailbox, EnumMail.SYSTEM_LETTER, Mail.SYSTEM_UUID, senderName, subject, message, null, 0L);
    }

    public void sendSystemRemittance(UUID addresseeUUID, String senderName, String subject, String message, long remittanceValue) {
        this.checkMailbox(addresseeUUID);
        Mailbox mailbox = this.manager.getMailboxesContainer().getPlayerMailbox(addresseeUUID);
        this.addMessage(mailbox, EnumMail.SYSTEM_REMITTANCE, Mail.SYSTEM_UUID, senderName, subject, message, null, remittanceValue);
    }

    public void sendSystemPackage(UUID addresseeUUID, String senderName, String subject, String message, Parcel parcel) {
        this.checkMailbox(addresseeUUID);
        Mailbox mailbox = this.manager.getMailboxesContainer().getPlayerMailbox(addresseeUUID);
        this.addMessage(mailbox, EnumMail.SYSTEM_PACKAGE, Mail.SYSTEM_UUID, senderName, subject, message, parcel, 0L);
    }
}

