/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.block;

import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.builders.BCBuildersBlocks;
import buildcraft.builders.tile.TileQuarry;
import buildcraft.lib.block.BlockBCTile_Neptune;
import buildcraft.lib.block.IBlockWithFacing;
import buildcraft.lib.misc.AdvancementUtil;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.tile.TileBC_Neptune;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockQuarry
extends BlockBCTile_Neptune
implements IBlockWithFacing {
    private static final ResourceLocation ADVANCEMENT = new ResourceLocation("buildcraftbuilders:shaping_the_world");

    public BlockQuarry(Material material, String id) {
        super(material, id);
    }

    protected void addProperties(List<IProperty<?>> properties) {
        super.addProperties(properties);
        properties.addAll(BuildCraftProperties.CONNECTED_MAP.values());
    }

    private boolean isConnected(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        TileEntity tile;
        EnumFacing facing = side;
        if (Arrays.asList(EnumFacing.field_176754_o).contains(facing)) {
            facing = EnumFacing.func_176731_b((int)(side.func_176736_b() + 2 + ((EnumFacing)state.func_177229_b(this.getFacingProperty())).func_176736_b()));
        }
        return (tile = world.func_175625_s(pos.func_177972_a(facing))) != null && tile.hasCapability(CapUtil.CAP_ITEMS, facing.func_176734_d());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            state = state.func_177226_a((IProperty)BuildCraftProperties.CONNECTED_MAP.get(face), (Comparable)Boolean.valueOf(this.isConnected(world, pos, state, face)));
        }
        return state;
    }

    public TileBC_Neptune createTileEntity(World world, IBlockState state) {
        return new TileQuarry();
    }

    public boolean canBeRotated(World world, BlockPos pos, IBlockState state) {
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileQuarry) {
            for (BlockPos blockPos : ((TileQuarry)tile).framePoses) {
                if (world.func_180495_p(blockPos).func_177230_c() != BCBuildersBlocks.frame) continue;
                world.func_175698_g(blockPos);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return SoundType.field_185858_k;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (placer instanceof EntityPlayer) {
            AdvancementUtil.unlockAdvancement((EntityPlayer)((EntityPlayer)placer), (ResourceLocation)ADVANCEMENT);
        }
    }
}

