/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.lib.misc.JsonUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;

public enum EnumNbtCompareOperation {
    EQ("="){

        @Override
        public boolean compare(NBTBase a, NBTBase b) {
            return Objects.equals(GSON.toJson((Object)a, NBTBase.class), GSON.toJson((Object)b, NBTBase.class));
        }
    }
    ,
    NQE("!="){

        @Override
        public boolean compare(NBTBase a, NBTBase b) {
            return !EQ.compare(a, b);
        }
    };

    private static final Gson GSON;
    public final String name;
    public static final JsonDeserializer<EnumNbtCompareOperation> DESERIALIZER;

    private EnumNbtCompareOperation(String name) {
        this.name = name;
    }

    public static EnumNbtCompareOperation byName(String name) {
        return Arrays.stream(EnumNbtCompareOperation.values()).filter(type -> type.name.equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Compare operation not found"));
    }

    public abstract boolean compare(NBTBase var1, NBTBase var2);

    static {
        GSON = JsonUtil.registerNbtSerializersDeserializers((GsonBuilder)new GsonBuilder()).create();
        DESERIALIZER = (json, typeOfT, context) -> EnumNbtCompareOperation.byName(json.getAsJsonPrimitive().getAsString());
    }
}

