/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.api.schematics.ISchematicBlock;
import buildcraft.builders.snapshot.Blueprint;
import buildcraft.builders.snapshot.FakeChunkProvider;
import buildcraft.builders.snapshot.Snapshot;
import buildcraft.builders.snapshot.Template;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveHandlerMP;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FakeWorld
extends World {
    private static final Biome BIOME = Biomes.field_76772_c;
    public static final BlockPos BLUEPRINT_OFFSET = new BlockPos(0, 127, 0);

    public FakeWorld() {
        super((ISaveHandler)new SaveHandlerMP(), new WorldInfo(new WorldSettings(0L, GameType.CREATIVE, true, false, WorldType.field_77137_b), "fake"), new WorldProvider(){

            public DimensionType func_186058_p() {
                return DimensionType.OVERWORLD;
            }
        }, new Profiler(), true);
        this.field_73020_y = new FakeChunkProvider(this);
    }

    public void clear() {
        ((FakeChunkProvider)this.field_73020_y).chunks.clear();
    }

    public void uploadSnapshot(Snapshot snapshot) {
        for (int z = 0; z < snapshot.size.func_177952_p(); ++z) {
            for (int y = 0; y < snapshot.size.func_177956_o(); ++y) {
                for (int x = 0; x < snapshot.size.func_177958_n(); ++x) {
                    ISchematicBlock schematicBlock;
                    BlockPos pos = new BlockPos(x, y, z).func_177971_a((Vec3i)BLUEPRINT_OFFSET);
                    if (snapshot instanceof Blueprint && !(schematicBlock = ((Blueprint)snapshot).palette.get(((Blueprint)snapshot).data[snapshot.posToIndex(x, y, z)])).isAir()) {
                        schematicBlock.buildWithoutChecks((World)this, pos);
                    }
                    if (!(snapshot instanceof Template) || !((Template)snapshot).data.get(snapshot.posToIndex(x, y, z))) continue;
                    this.func_175656_a(pos, Blocks.field_150371_ca.func_176223_P());
                }
            }
        }
        if (snapshot instanceof Blueprint) {
            ((Blueprint)snapshot).entities.forEach(schematicEntity -> schematicEntity.buildWithoutChecks((World)this, BLUEPRINT_OFFSET));
        }
    }

    public BlockPos func_175694_M() {
        return BLUEPRINT_OFFSET;
    }

    protected IChunkProvider func_72970_h() {
        return this.field_73020_y;
    }

    protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
        return true;
    }

    public Biome func_180494_b(BlockPos pos) {
        return BIOME;
    }

    public Biome getBiomeForCoordsBody(BlockPos pos) {
        return BIOME;
    }

    public BiomeProvider func_72959_q() {
        return new BiomeProvider(this.field_72986_A){

            public List<Biome> func_76932_a() {
                return Collections.emptyList();
            }

            public Biome func_180631_a(BlockPos pos) {
                return BIOME;
            }

            public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
                return BIOME;
            }

            public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
                return biomes;
            }

            public Biome[] func_76933_b(@Nullable Biome[] oldBiomeList, int x, int z, int width, int depth) {
                return oldBiomeList;
            }

            public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
                return listToReuse;
            }

            public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
                return false;
            }

            @Nullable
            public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
                return BlockPos.field_177992_a;
            }

            public void func_76938_b() {
            }

            public GenLayer[] getModdedBiomeGenerators(WorldType worldType, long seed, GenLayer[] original) {
                return original;
            }

            public boolean func_190944_c() {
                return true;
            }

            public Biome func_190943_d() {
                return BIOME;
            }
        };
    }
}

