/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.network;

import com.carpentersblocks.network.TilePacket;
import com.carpentersblocks.tileentity.CbTileEntity;
import com.carpentersblocks.util.EntityLivingUtil;
import com.carpentersblocks.util.attribute.EnumAttributeLocation;
import com.carpentersblocks.util.attribute.EnumAttributeType;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketEnrichPlant
extends TilePacket {
    private int hexColor;

    public PacketEnrichPlant() {
    }

    public PacketEnrichPlant(BlockPos blockPos, int hexColor) {
        super(blockPos);
        this.hexColor = hexColor;
    }

    @Override
    public void processData(EntityPlayer entityPlayer, ByteBufInputStream bbis) throws IOException {
        super.processData(entityPlayer, bbis);
        World world = entityPlayer.func_130014_f_();
        this.hexColor = bbis.readInt();
        TileEntity tileEntity = world.func_175625_s(this._blockPos);
        if (tileEntity != null && tileEntity instanceof CbTileEntity) {
            CbTileEntity cbTileEntity = (CbTileEntity)tileEntity;
            if (this.hexColor != 0xFFFFFF && !cbTileEntity.getAttributeHelper().hasAttribute(EnumAttributeLocation.HOST, EnumAttributeType.FERTILIZER)) {
                cbTileEntity.addAttribute(EnumAttributeLocation.HOST, EnumAttributeType.FERTILIZER, new ItemStack(Items.field_151100_aR, 1, 15));
                EntityLivingUtil.decrementCurrentSlot(entityPlayer);
            }
        }
    }

    @Override
    public void appendData(PacketBuffer buffer) throws IOException {
        super.appendData(buffer);
        buffer.writeInt(this.hexColor);
    }
}

