/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.renderer.Quad;
import com.carpentersblocks.renderer.UV;
import com.carpentersblocks.util.attribute.EnumAttributeLocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.vecmath.Point2d;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class QuadUtil {
    public static Point2d vec3dToPoint(EnumFacing facing, Vec3d vec3d) {
        switch (facing.func_176740_k()) {
            case X: {
                return new Point2d(vec3d.field_72449_c, vec3d.field_72448_b);
            }
            case Y: {
                return new Point2d(vec3d.field_72450_a, vec3d.field_72449_c);
            }
        }
        return new Point2d(vec3d.field_72450_a, vec3d.field_72448_b);
    }

    private static Point2d[] getBoundingPlane(EnumFacing facing, List<Vec3d> vec3ds) {
        double minU = 0.0;
        double maxU = 1.0;
        double minV = 0.0;
        double maxV = 1.0;
        for (Vec3d vec : vec3ds) {
            Point2d pt = QuadUtil.vec3dToPoint(facing, vec);
            minU = Math.min(minU, pt.getX());
            maxU = Math.max(maxU, pt.getX());
            minV = Math.min(minV, pt.getY());
            maxV = Math.max(maxV, pt.getY());
        }
        switch (facing) {
            case DOWN: {
                return new Point2d[]{new Point2d(minU, maxV), new Point2d(minU, minV), new Point2d(maxU, minV), new Point2d(maxU, maxV)};
            }
            case UP: {
                return new Point2d[]{new Point2d(minU, minV), new Point2d(minU, maxV), new Point2d(maxU, maxV), new Point2d(maxU, minV)};
            }
            case NORTH: {
                return new Point2d[]{new Point2d(maxU, maxV), new Point2d(maxU, minV), new Point2d(minU, minV), new Point2d(minU, maxV)};
            }
            case SOUTH: {
                return new Point2d[]{new Point2d(minU, maxV), new Point2d(minU, minV), new Point2d(maxU, minV), new Point2d(maxU, maxV)};
            }
            case WEST: {
                return new Point2d[]{new Point2d(minU, maxV), new Point2d(minU, minV), new Point2d(maxU, minV), new Point2d(maxU, maxV)};
            }
        }
        return new Point2d[]{new Point2d(maxU, maxV), new Point2d(maxU, minV), new Point2d(minU, minV), new Point2d(minU, maxV)};
    }

    public static boolean isValid(Quad quad) {
        if (quad == null || quad.getVecs() == null || quad.getVecs().length != 4) {
            return false;
        }
        Vec3d[] vecs = quad.getVecs();
        Comparator<Vec3d> comparator = new Comparator<Vec3d>(){

            @Override
            public int compare(Vec3d vec1, Vec3d vec2) {
                if (MathHelper.func_180185_a((float)((float)vec1.field_72450_a), (float)((float)vec2.field_72450_a)) && MathHelper.func_180185_a((float)((float)vec1.field_72448_b), (float)((float)vec2.field_72448_b)) && MathHelper.func_180185_a((float)((float)vec1.field_72449_c), (float)((float)vec2.field_72449_c))) {
                    return 0;
                }
                return 1;
            }
        };
        HashSet<Vec3d> set = new HashSet<Vec3d>(Arrays.asList(vecs));
        return set.size() >= 3;
    }

    private static Vec3d[] getCornersUsingUniqueness(EnumFacing facing, Point2d[] bounds, List<Vec3d> vec3ds) {
        Vec3d[] corners = new Vec3d[4];
        block0: for (int i = 0; i < bounds.length; ++i) {
            double[] proximity = new double[vec3ds.size()];
            for (int j = 0; j < vec3ds.size(); ++j) {
                Point2d pt = QuadUtil.vec3dToPoint(facing, vec3ds.get(j));
                proximity[j] = Math.ceil(pt.distance(bounds[i]) * 10000.0) / 10000.0;
            }
            TreeMap map = new TreeMap();
            for (int j = 0; j < proximity.length; ++j) {
                if (!map.containsKey(proximity[j])) {
                    map.put(proximity[j], new ArrayList());
                }
                ((List)map.get(proximity[j])).add(vec3ds.get(j));
            }
            Object corner = null;
            if (((List)map.get(map.firstKey())).size() != 1) continue;
            for (int j = 0; j < proximity.length; ++j) {
                if (proximity[j] != (Double)map.firstKey()) continue;
                corners[i] = (Vec3d)((List)map.get(map.firstKey())).get(0);
                continue block0;
            }
        }
        ArrayList<Vec3d> unassigned = new ArrayList<Vec3d>(vec3ds);
        unassigned.removeAll(Arrays.asList(corners));
        if (!unassigned.isEmpty()) {
            for (int i = 0; i < corners.length; ++i) {
                if (corners[i] != null) continue;
                corners[i] = (Vec3d)unassigned.get(0);
            }
        }
        return corners;
    }

    public static Vec3d[] sortVec3dsByFacing(EnumFacing facing, Vec3d[] inVecs) {
        Vec3d[] cornerList = null;
        HashSet<Point2d> set = new HashSet<Point2d>();
        for (int i = 0; i < inVecs.length; ++i) {
            if (inVecs[i] == null) continue;
            set.add(QuadUtil.vec3dToPoint(facing, inVecs[i]));
        }
        if (set.size() > 2) {
            ArrayList<Vec3d> list = new ArrayList<Vec3d>(Arrays.asList(inVecs));
            Point2d[] bounds = QuadUtil.getBoundingPlane(facing, list);
            cornerList = QuadUtil.getCornersUsingUniqueness(facing, bounds, list);
            int cornerCount = 0;
            for (int i = 0; i < cornerList.length; ++i) {
                if (cornerList[i] == null) continue;
                ++cornerCount;
            }
            if (cornerCount >= 3) {
                if (cornerList[0] == null) {
                    cornerList[0] = cornerList[1];
                } else if (cornerList[1] == null) {
                    cornerList[1] = cornerList[0];
                } else if (cornerList[2] == null) {
                    cornerList[2] = cornerList[3];
                } else if (cornerList[3] == null) {
                    cornerList[3] = cornerList[2];
                }
            }
        }
        return cornerList;
    }

    public static UV[] getUV(Quad quad, boolean isFloatingOverlay, EnumAttributeLocation location) {
        if (quad.isObliqueSlope()) {
            return QuadUtil.getUVObliqueSlope(quad, isFloatingOverlay, location);
        }
        return QuadUtil.getUV(quad, isFloatingOverlay);
    }

    public static UV[] getUVObliqueSlope(Quad quad, boolean isFloatingOverlay, EnumAttributeLocation location) {
        Vec3d TL = quad.getVecs()[0];
        Vec3d BL = quad.getVecs()[1];
        Vec3d BR = quad.getVecs()[2];
        Vec3d TR = quad.getVecs()[3];
        boolean[] midPt = new boolean[4];
        if (QuadUtil.compare(TL, BL) == 0) {
            if (QuadUtil.compare(TL.field_72448_b, TR.field_72448_b) < 0) {
                midPt[2] = true;
            } else if (QuadUtil.compare(TL.field_72448_b, BR.field_72448_b) > 0) {
                midPt[2] = true;
            }
        } else if (QuadUtil.compare(TL.field_72448_b, TR.field_72448_b) > 0) {
            midPt[0] = true;
        } else if (QuadUtil.compare(BL.field_72448_b, BR.field_72448_b) < 0) {
            midPt[1] = true;
        }
        if (!EnumAttributeLocation.HOST.equals((Object)location)) {
            quad = new Quad(quad);
            Vec3d[] vecs = quad.getVecs();
            double translation = EnumFacing.DOWN.equals((Object)quad.getYSlope()) ? -1.0 * Math.min(BL.field_72448_b, BR.field_72448_b) : -1.0 * (Math.max(TL.field_72448_b, TR.field_72448_b) - 1.0);
            if (Double.compare(0.0, translation) != 0) {
                TL = TL.func_72441_c(0.0, translation, 0.0);
                BL = BL.func_72441_c(0.0, translation, 0.0);
                BR = BR.func_72441_c(0.0, translation, 0.0);
                TR = TR.func_72441_c(0.0, translation, 0.0);
            }
        }
        switch (quad.getCardinalFacing()) {
            case NORTH: {
                if (isFloatingOverlay && midPt[0]) {
                    return new UV[]{new UV(0.5, 0.0).invertU(), new UV(BL.field_72450_a, TL.field_72448_b - BL.field_72448_b).invertU(), new UV(BR.field_72450_a, TL.field_72448_b - BR.field_72448_b).invertU(), new UV(TR.field_72450_a, TL.field_72448_b - TR.field_72448_b).invertU()};
                }
                return new UV[]{new UV(midPt[0] ? 0.5 : TL.field_72450_a, TL.field_72448_b).invertUV(), new UV(midPt[1] ? 0.5 : BL.field_72450_a, BL.field_72448_b).invertUV(), new UV(midPt[2] ? 0.5 : BR.field_72450_a, BR.field_72448_b).invertUV(), new UV(midPt[3] ? 0.5 : TR.field_72450_a, TR.field_72448_b).invertUV()};
            }
            case SOUTH: {
                if (isFloatingOverlay && midPt[0]) {
                    return new UV[]{new UV(0.5, 0.0), new UV(BL.field_72450_a, TL.field_72448_b - BL.field_72448_b), new UV(BR.field_72450_a, TL.field_72448_b - BR.field_72448_b), new UV(TR.field_72450_a, TL.field_72448_b - TR.field_72448_b)};
                }
                return new UV[]{new UV(midPt[0] ? 0.5 : TL.field_72450_a, TL.field_72448_b).invertV(), new UV(midPt[1] ? 0.5 : BL.field_72450_a, BL.field_72448_b).invertV(), new UV(midPt[2] ? 0.5 : BR.field_72450_a, BR.field_72448_b).invertV(), new UV(midPt[3] ? 0.5 : TR.field_72450_a, TR.field_72448_b).invertV()};
            }
            case WEST: {
                if (isFloatingOverlay && midPt[0]) {
                    return new UV[]{new UV(0.5, 0.0), new UV(BL.field_72449_c, TL.field_72448_b - BL.field_72448_b), new UV(BR.field_72449_c, TL.field_72448_b - BR.field_72448_b), new UV(TR.field_72449_c, TL.field_72448_b - TR.field_72448_b)};
                }
                return new UV[]{new UV(midPt[0] ? 0.5 : TL.field_72449_c, TL.field_72448_b).invertV(), new UV(midPt[1] ? 0.5 : BL.field_72449_c, BL.field_72448_b).invertV(), new UV(midPt[2] ? 0.5 : BR.field_72449_c, BR.field_72448_b).invertV(), new UV(midPt[3] ? 0.5 : TR.field_72449_c, TR.field_72448_b).invertV()};
            }
        }
        if (isFloatingOverlay && midPt[0]) {
            return new UV[]{new UV(0.5, 0.0).invertU(), new UV(BL.field_72449_c, TL.field_72448_b - BL.field_72448_b).invertU(), new UV(BR.field_72449_c, TL.field_72448_b - BR.field_72448_b).invertU(), new UV(TR.field_72449_c, TL.field_72448_b - TR.field_72448_b).invertU()};
        }
        return new UV[]{new UV(midPt[0] ? 0.5 : TL.field_72449_c, TL.field_72448_b).invertUV(), new UV(midPt[1] ? 0.5 : BL.field_72449_c, BL.field_72448_b).invertUV(), new UV(midPt[2] ? 0.5 : BR.field_72449_c, BR.field_72448_b).invertUV(), new UV(midPt[3] ? 0.5 : TR.field_72449_c, TR.field_72448_b).invertUV()};
    }

    public static UV[] getUV(Quad quad, boolean isFloatingOverlay) {
        Vec3d TL = quad.getVecs()[0];
        Vec3d BL = quad.getVecs()[1];
        Vec3d BR = quad.getVecs()[2];
        Vec3d TR = quad.getVecs()[3];
        switch (quad.getFacing()) {
            case DOWN: {
                if (quad.hasFloatingUV()) {
                    switch (quad.getUVFloat()) {
                        case NORTH: {
                            return new UV[]{new UV(TL.field_72450_a, 1.0), new UV(BL.field_72450_a, TL.field_72449_c - BL.field_72449_c).invertV(), new UV(BR.field_72450_a, TR.field_72449_c - BR.field_72449_c).invertV(), new UV(TR.field_72450_a, 1.0)};
                        }
                        case SOUTH: {
                            return new UV[]{new UV(TL.field_72450_a, TL.field_72449_c - BL.field_72449_c), new UV(BL.field_72450_a, 0.0), new UV(BR.field_72450_a, 0.0), new UV(TR.field_72450_a, TR.field_72449_c - BR.field_72449_c)};
                        }
                        case WEST: {
                            return new UV[]{new UV(TR.field_72450_a - TL.field_72450_a, TL.field_72449_c).invertV(), new UV(BR.field_72450_a - BL.field_72450_a, BL.field_72449_c).invertV(), new UV(0.0, BR.field_72449_c).invertV(), new UV(0.0, TR.field_72449_c).invertV()};
                        }
                    }
                    return new UV[]{new UV(1.0, TL.field_72449_c).invertV(), new UV(1.0, BL.field_72449_c).invertV(), new UV(BR.field_72450_a - BL.field_72450_a, BR.field_72449_c).invertUV(), new UV(TR.field_72450_a - TL.field_72450_a, TR.field_72449_c).invertUV()};
                }
                return new UV[]{new UV(TL.field_72450_a + quad.getUVOffset().field_72450_a, TL.field_72449_c + quad.getUVOffset().field_72449_c).invertV(), new UV(BL.field_72450_a + quad.getUVOffset().field_72450_a, BL.field_72449_c + quad.getUVOffset().field_72449_c).invertV(), new UV(BR.field_72450_a + quad.getUVOffset().field_72450_a, BR.field_72449_c + quad.getUVOffset().field_72449_c).invertV(), new UV(TR.field_72450_a + quad.getUVOffset().field_72450_a, TR.field_72449_c + quad.getUVOffset().field_72449_c).invertV()};
            }
            case UP: {
                if (quad.hasFloatingUV()) {
                    switch (quad.getUVFloat()) {
                        case NORTH: {
                            return new UV[]{new UV(TL.field_72450_a, 0.0), new UV(BL.field_72450_a, BL.field_72449_c - TL.field_72449_c), new UV(BR.field_72450_a, BR.field_72449_c - TR.field_72449_c), new UV(TR.field_72450_a, 0.0)};
                        }
                        case SOUTH: {
                            return new UV[]{new UV(TL.field_72450_a, 1.0), new UV(BL.field_72450_a, BL.field_72449_c - TL.field_72449_c).invertV(), new UV(BR.field_72450_a, BR.field_72449_c - TR.field_72449_c).invertV(), new UV(TR.field_72450_a, 1.0)};
                        }
                        case WEST: {
                            return new UV[]{new UV(TR.field_72450_a - TL.field_72450_a, TL.field_72449_c), new UV(BR.field_72450_a - BL.field_72450_a, BL.field_72449_c), new UV(0.0, BR.field_72449_c), new UV(0.0, TR.field_72449_c)};
                        }
                    }
                    return new UV[]{new UV(1.0, TL.field_72449_c), new UV(TR.field_72450_a - TL.field_72450_a, BL.field_72449_c).invertU(), new UV(BR.field_72450_a - BL.field_72450_a, BR.field_72449_c).invertU(), new UV(1.0, TR.field_72449_c)};
                }
                return new UV[]{new UV(TL.field_72450_a + quad.getUVOffset().field_72450_a, TL.field_72449_c + quad.getUVOffset().field_72449_c), new UV(BL.field_72450_a + quad.getUVOffset().field_72450_a, BL.field_72449_c + quad.getUVOffset().field_72449_c), new UV(BR.field_72450_a + quad.getUVOffset().field_72450_a, BR.field_72449_c + quad.getUVOffset().field_72449_c), new UV(TR.field_72450_a + quad.getUVOffset().field_72450_a, TR.field_72449_c + quad.getUVOffset().field_72449_c)};
            }
            case NORTH: {
                if (isFloatingOverlay) {
                    return new UV[]{new UV(TL.field_72450_a, 0.0).invertU(), new UV(BL.field_72450_a, TL.field_72448_b - BL.field_72448_b).invertU(), new UV(BR.field_72450_a, TR.field_72448_b - BR.field_72448_b).invertU(), new UV(TR.field_72450_a, 0.0).invertU()};
                }
                if (quad.hasFloatingUV()) {
                    switch (quad.getUVFloat()) {
                        case DOWN: {
                            return new UV[]{new UV(TL.field_72450_a, 1.0).invertU(), new UV(BL.field_72450_a, TL.field_72448_b - BL.field_72448_b).invertUV(), new UV(BR.field_72450_a, TR.field_72448_b - BR.field_72448_b).invertUV(), new UV(TR.field_72450_a, 1.0).invertU()};
                        }
                        case UP: {
                            return new UV[]{new UV(TL.field_72450_a, TL.field_72448_b - BL.field_72448_b).invertU(), new UV(BL.field_72450_a, 0.0).invertU(), new UV(BR.field_72450_a, 0.0).invertU(), new UV(TR.field_72450_a, TR.field_72448_b - BR.field_72448_b).invertU()};
                        }
                        case WEST: {
                            return new UV[]{new UV(1.0, TL.field_72448_b).invertV(), new UV(1.0, BL.field_72448_b).invertV(), new UV(BL.field_72450_a - BR.field_72450_a, BR.field_72448_b).invertUV(), new UV(TL.field_72450_a - TR.field_72450_a, TR.field_72448_b).invertUV()};
                        }
                    }
                    return new UV[]{new UV(TL.field_72450_a - TR.field_72450_a, TL.field_72448_b).invertV(), new UV(BL.field_72450_a - BR.field_72450_a, BL.field_72448_b).invertV(), new UV(0.0, BR.field_72448_b).invertV(), new UV(0.0, TR.field_72448_b).invertV()};
                }
                return new UV[]{new UV(TL.field_72450_a + quad.getUVOffset().field_72450_a, TL.field_72448_b + quad.getUVOffset().field_72448_b).invertUV(), new UV(BL.field_72450_a + quad.getUVOffset().field_72450_a, BL.field_72448_b + quad.getUVOffset().field_72448_b).invertUV(), new UV(BR.field_72450_a + quad.getUVOffset().field_72450_a, BR.field_72448_b + quad.getUVOffset().field_72448_b).invertUV(), new UV(TR.field_72450_a + quad.getUVOffset().field_72450_a, TR.field_72448_b + quad.getUVOffset().field_72448_b).invertUV()};
            }
            case SOUTH: {
                if (isFloatingOverlay) {
                    return new UV[]{new UV(TL.field_72450_a, 0.0), new UV(BL.field_72450_a, TL.field_72448_b - BL.field_72448_b), new UV(BR.field_72450_a, TR.field_72448_b - BR.field_72448_b), new UV(TR.field_72450_a, 0.0)};
                }
                if (quad.hasFloatingUV()) {
                    switch (quad.getUVFloat()) {
                        case DOWN: {
                            return new UV[]{new UV(TL.field_72450_a, 1.0), new UV(BL.field_72450_a, TL.field_72448_b - BL.field_72448_b).invertV(), new UV(BR.field_72450_a, TR.field_72448_b - BR.field_72448_b).invertV(), new UV(TR.field_72450_a, 1.0)};
                        }
                        case UP: {
                            return new UV[]{new UV(TL.field_72450_a, TL.field_72448_b - BL.field_72448_b), new UV(BL.field_72450_a, 0.0), new UV(BR.field_72450_a, 0.0), new UV(TR.field_72450_a, TR.field_72448_b - BR.field_72448_b)};
                        }
                        case WEST: {
                            return new UV[]{new UV(0.0, TL.field_72448_b).invertV(), new UV(0.0, BL.field_72448_b).invertV(), new UV(BR.field_72450_a - BL.field_72450_a, BR.field_72448_b).invertV(), new UV(TR.field_72450_a - TL.field_72450_a, TR.field_72448_b).invertV()};
                        }
                    }
                    return new UV[]{new UV(TR.field_72450_a - TL.field_72450_a, TL.field_72448_b).invertUV(), new UV(BR.field_72450_a - BL.field_72450_a, BL.field_72448_b).invertUV(), new UV(1.0, BR.field_72448_b).invertV(), new UV(1.0, TR.field_72448_b).invertV()};
                }
                return new UV[]{new UV(TL.field_72450_a + quad.getUVOffset().field_72450_a, TL.field_72448_b + quad.getUVOffset().field_72448_b).invertV(), new UV(BL.field_72450_a + quad.getUVOffset().field_72450_a, BL.field_72448_b + quad.getUVOffset().field_72448_b).invertV(), new UV(BR.field_72450_a + quad.getUVOffset().field_72450_a, BR.field_72448_b + quad.getUVOffset().field_72448_b).invertV(), new UV(TR.field_72450_a + quad.getUVOffset().field_72450_a, TR.field_72448_b + quad.getUVOffset().field_72448_b).invertV()};
            }
            case WEST: {
                if (isFloatingOverlay) {
                    return new UV[]{new UV(TL.field_72449_c, 0.0), new UV(BL.field_72449_c, TL.field_72448_b - BL.field_72448_b), new UV(BR.field_72449_c, TR.field_72448_b - BR.field_72448_b), new UV(TR.field_72449_c, 0.0)};
                }
                if (quad.hasFloatingUV()) {
                    switch (quad.getUVFloat()) {
                        case DOWN: {
                            return new UV[]{new UV(TL.field_72449_c, 1.0), new UV(BL.field_72449_c, TL.field_72448_b - BL.field_72448_b).invertV(), new UV(BR.field_72449_c, TR.field_72448_b - BR.field_72448_b).invertV(), new UV(TR.field_72449_c, 1.0)};
                        }
                        case UP: {
                            return new UV[]{new UV(TL.field_72449_c, TL.field_72448_b - BL.field_72448_b), new UV(BL.field_72449_c, 0.0), new UV(BR.field_72449_c, 0.0), new UV(TR.field_72449_c, TR.field_72448_b - BR.field_72448_b)};
                        }
                        case NORTH: {
                            return new UV[]{new UV(0.0, TL.field_72448_b).invertV(), new UV(0.0, BL.field_72448_b).invertV(), new UV(BR.field_72449_c - BL.field_72449_c, BR.field_72448_b).invertV(), new UV(TR.field_72449_c - TL.field_72449_c, TR.field_72448_b).invertV()};
                        }
                    }
                    return new UV[]{new UV(TR.field_72449_c - TL.field_72449_c, TL.field_72448_b).invertUV(), new UV(BR.field_72449_c - BL.field_72449_c, BL.field_72448_b).invertUV(), new UV(1.0, BR.field_72448_b).invertV(), new UV(1.0, TR.field_72448_b).invertV()};
                }
                return new UV[]{new UV(TL.field_72449_c + quad.getUVOffset().field_72449_c, TL.field_72448_b + quad.getUVOffset().field_72448_b).invertV(), new UV(BL.field_72449_c + quad.getUVOffset().field_72449_c, BL.field_72448_b + quad.getUVOffset().field_72448_b).invertV(), new UV(BR.field_72449_c + quad.getUVOffset().field_72449_c, BR.field_72448_b + quad.getUVOffset().field_72448_b).invertV(), new UV(TR.field_72449_c + quad.getUVOffset().field_72449_c, TR.field_72448_b + quad.getUVOffset().field_72448_b).invertV()};
            }
            case EAST: {
                if (isFloatingOverlay) {
                    return new UV[]{new UV(TL.field_72449_c, 0.0).invertU(), new UV(BL.field_72449_c, TL.field_72448_b - BL.field_72448_b).invertU(), new UV(BR.field_72449_c, TR.field_72448_b - BR.field_72448_b).invertU(), new UV(TR.field_72449_c, 0.0).invertU()};
                }
                if (quad.hasFloatingUV()) {
                    switch (quad.getUVFloat()) {
                        case DOWN: {
                            return new UV[]{new UV(TL.field_72449_c, 1.0).invertU(), new UV(BL.field_72449_c, TL.field_72448_b - BL.field_72448_b).invertUV(), new UV(BR.field_72449_c, TR.field_72448_b - BR.field_72448_b).invertUV(), new UV(TR.field_72449_c, 1.0).invertU()};
                        }
                        case UP: {
                            return new UV[]{new UV(TL.field_72449_c, TL.field_72448_b - BL.field_72448_b).invertU(), new UV(BL.field_72449_c, 0.0).invertU(), new UV(BR.field_72449_c, 0.0).invertU(), new UV(TR.field_72449_c, TR.field_72448_b - BR.field_72448_b).invertU()};
                        }
                        case NORTH: {
                            return new UV[]{new UV(1.0, TL.field_72448_b).invertV(), new UV(1.0, BL.field_72448_b).invertV(), new UV(BL.field_72449_c - BR.field_72449_c, BR.field_72448_b).invertUV(), new UV(TL.field_72449_c - TR.field_72449_c, TR.field_72448_b).invertUV()};
                        }
                    }
                    return new UV[]{new UV(TL.field_72449_c - TR.field_72449_c, TL.field_72448_b).invertV(), new UV(BL.field_72449_c - BR.field_72449_c, BL.field_72448_b).invertV(), new UV(0.0, BR.field_72448_b).invertV(), new UV(0.0, TR.field_72448_b).invertV()};
                }
                return new UV[]{new UV(TL.field_72449_c + quad.getUVOffset().field_72449_c, TL.field_72448_b + quad.getUVOffset().field_72448_b).invertUV(), new UV(BL.field_72449_c + quad.getUVOffset().field_72449_c, BL.field_72448_b + quad.getUVOffset().field_72448_b).invertUV(), new UV(BR.field_72449_c + quad.getUVOffset().field_72449_c, BR.field_72448_b + quad.getUVOffset().field_72448_b).invertUV(), new UV(TR.field_72449_c + quad.getUVOffset().field_72449_c, TR.field_72448_b + quad.getUVOffset().field_72448_b).invertUV()};
            }
        }
        return null;
    }

    public static List<Quad> getPerpendicularQuads(Quad quad, double depth) {
        ArrayList<Quad> list = new ArrayList<Quad>();
        Vec3d[] vecs = quad.getVecs();
        switch (quad.getSideCoverAltFacing()) {
            case DOWN: {
                list.add(Quad.getUnsortedQuad(EnumFacing.NORTH, vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, -depth, 0.0), vecs[1].func_72441_c(0.0, -depth, 0.0), vecs[1].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getUnsortedQuad(EnumFacing.SOUTH, vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(0.0, -depth, 0.0), vecs[3].func_72441_c(0.0, -depth, 0.0), vecs[3].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getUnsortedQuad(EnumFacing.WEST, vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, -depth, 0.0), vecs[0].func_72441_c(0.0, -depth, 0.0), vecs[0].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getUnsortedQuad(EnumFacing.EAST, vecs[3].func_72441_c(0.0, 0.0, 0.0), vecs[3].func_72441_c(0.0, -depth, 0.0), vecs[2].func_72441_c(0.0, -depth, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0)));
                QuadUtil.preparePerdendicularQuads(list, EnumFacing.DOWN);
                break;
            }
            case UP: {
                list.add(Quad.getUnsortedQuad(EnumFacing.NORTH, vecs[3].func_72441_c(0.0, depth, 0.0), vecs[3].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(0.0, depth, 0.0)));
                list.add(Quad.getUnsortedQuad(EnumFacing.SOUTH, vecs[1].func_72441_c(0.0, depth, 0.0), vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, depth, 0.0)));
                list.add(Quad.getUnsortedQuad(EnumFacing.WEST, vecs[0].func_72441_c(0.0, depth, 0.0), vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, depth, 0.0)));
                list.add(Quad.getUnsortedQuad(EnumFacing.EAST, vecs[2].func_72441_c(0.0, depth, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[3].func_72441_c(0.0, 0.0, 0.0), vecs[3].func_72441_c(0.0, depth, 0.0)));
                QuadUtil.preparePerdendicularQuads(list, EnumFacing.UP);
                break;
            }
            case NORTH: {
                list.add(Quad.getUnsortedQuad(EnumFacing.DOWN, vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, -depth), vecs[1].func_72441_c(0.0, 0.0, -depth), vecs[1].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getUnsortedQuad(EnumFacing.UP, vecs[3].func_72441_c(0.0, 0.0, -depth), vecs[3].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(0.0, 0.0, -depth)));
                list.add(Quad.getUnsortedQuad(EnumFacing.WEST, vecs[3].func_72441_c(0.0, 0.0, -depth), vecs[2].func_72441_c(0.0, 0.0, -depth), vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[3].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getUnsortedQuad(EnumFacing.EAST, vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, 0.0, -depth), vecs[0].func_72441_c(0.0, 0.0, -depth)));
                QuadUtil.preparePerdendicularQuads(list, EnumFacing.NORTH);
                break;
            }
            case SOUTH: {
                list.add(Quad.getUnsortedQuad(EnumFacing.DOWN, vecs[1].func_72441_c(0.0, 0.0, depth), vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, depth)));
                list.add(Quad.getUnsortedQuad(EnumFacing.UP, vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(0.0, 0.0, depth), vecs[3].func_72441_c(0.0, 0.0, depth), vecs[3].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getUnsortedQuad(EnumFacing.WEST, vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, 0.0, depth), vecs[0].func_72441_c(0.0, 0.0, depth)));
                list.add(Quad.getUnsortedQuad(EnumFacing.EAST, vecs[3].func_72441_c(0.0, 0.0, depth), vecs[2].func_72441_c(0.0, 0.0, depth), vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[3].func_72441_c(0.0, 0.0, 0.0)));
                QuadUtil.preparePerdendicularQuads(list, EnumFacing.SOUTH);
                break;
            }
            case WEST: {
                list.add(Quad.getUnsortedQuad(EnumFacing.DOWN, vecs[2].func_72441_c(-depth, 0.0, 0.0), vecs[1].func_72441_c(-depth, 0.0, 0.0), vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getUnsortedQuad(EnumFacing.UP, vecs[0].func_72441_c(-depth, 0.0, 0.0), vecs[3].func_72441_c(-depth, 0.0, 0.0), vecs[3].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getUnsortedQuad(EnumFacing.NORTH, vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(-depth, 0.0, 0.0), vecs[0].func_72441_c(-depth, 0.0, 0.0)));
                list.add(Quad.getUnsortedQuad(EnumFacing.SOUTH, vecs[3].func_72441_c(-depth, 0.0, 0.0), vecs[2].func_72441_c(-depth, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[3].func_72441_c(0.0, 0.0, 0.0)));
                QuadUtil.preparePerdendicularQuads(list, EnumFacing.WEST);
                break;
            }
            case EAST: {
                list.add(Quad.getUnsortedQuad(EnumFacing.DOWN, vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[2].func_72441_c(depth, 0.0, 0.0), vecs[1].func_72441_c(depth, 0.0, 0.0)));
                list.add(Quad.getUnsortedQuad(EnumFacing.UP, vecs[3].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[0].func_72441_c(depth, 0.0, 0.0), vecs[3].func_72441_c(depth, 0.0, 0.0)));
                list.add(Quad.getUnsortedQuad(EnumFacing.NORTH, vecs[3].func_72441_c(depth, 0.0, 0.0), vecs[2].func_72441_c(depth, 0.0, 0.0), vecs[2].func_72441_c(0.0, 0.0, 0.0), vecs[3].func_72441_c(0.0, 0.0, 0.0)));
                list.add(Quad.getUnsortedQuad(EnumFacing.SOUTH, vecs[0].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(0.0, 0.0, 0.0), vecs[1].func_72441_c(depth, 0.0, 0.0), vecs[0].func_72441_c(depth, 0.0, 0.0)));
                QuadUtil.preparePerdendicularQuads(list, EnumFacing.EAST);
            }
        }
        return list;
    }

    private static void preparePerdendicularQuads(List<Quad> list, EnumFacing facing) {
        Iterator<Quad> iter = list.iterator();
        while (iter.hasNext()) {
            Quad quad = iter.next();
            if (quad == null) {
                iter.remove();
                continue;
            }
            quad.setUVFloat(facing);
        }
    }

    public static int compare(double d1, double d2) {
        double diff = d1 - d2;
        double epsilon = 1.0E-4;
        if (diff < -epsilon) {
            return -1;
        }
        if (diff > epsilon) {
            return 1;
        }
        return 0;
    }

    public static int compare(Vec3d v1, Vec3d v2) {
        return QuadUtil.compare(v1.field_72450_a, v2.field_72450_a) + QuadUtil.compare(v1.field_72448_b, v2.field_72448_b) + QuadUtil.compare(v1.field_72449_c, v2.field_72449_c);
    }
}

