/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_playerslist.client.gui.playerslist;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.contextmenu.GUIContextMenu;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.screen.text.GUITextField;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.OxygenGUIHelper;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.api.PrivilegeProviderClient;
import austeretony.oxygen_core.client.gui.elements.ActivityStatusGUIDDList;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButtonPanel;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIContextMenu;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIContextMenuElement;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.elements.OxygenGUITextField;
import austeretony.oxygen_core.client.gui.elements.OxygenSorterGUIElement;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.PlayerSharedData;
import austeretony.oxygen_core.common.main.EnumOxygenPrivilege;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_core.server.OxygenPlayerData;
import austeretony.oxygen_playerslist.client.gui.playerslist.PlayersListEntryGUIButton;
import austeretony.oxygen_playerslist.client.gui.playerslist.PlayersListGUIFiller;
import austeretony.oxygen_playerslist.client.gui.playerslist.PlayersListGUIScreen;
import austeretony.oxygen_playerslist.client.input.PlayersListKeyHandler;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class PlayersListGUISection
extends AbstractGUISection {
    private final PlayersListGUIScreen screen;
    private OxygenGUIText playersOnlineTextLabel;
    private ActivityStatusGUIDDList activityStatusDDList;
    private OxygenSorterGUIElement statusSorter;
    private OxygenSorterGUIElement usernameSorter;
    private OxygenGUITextField searchField;
    private OxygenGUIButtonPanel playersPanel;

    public PlayersListGUISection(PlayersListGUIScreen screen) {
        super((AbstractGUIScreen)screen);
        this.screen = screen;
    }

    public void init() {
        this.addElement((GUIBaseElement)new PlayersListGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, ClientReference.localize((String)"oxygen_playerslist.gui.playerslist.title", (Object[])new Object[0]), GUISettings.get().getTitleScale(), GUISettings.get().getEnabledTextColor()));
        this.playersOnlineTextLabel = new OxygenGUIText(0, 18, "", GUISettings.get().getSubTextScale() - 0.05f, GUISettings.get().getEnabledTextColor());
        this.addElement((GUIBaseElement)this.playersOnlineTextLabel);
        this.statusSorter = new OxygenSorterGUIElement(13, 27, OxygenSorterGUIElement.EnumSorting.DOWN, ClientReference.localize((String)"oxygen.sorting.status", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.statusSorter);
        this.statusSorter.setClickListener(sorting -> {
            this.usernameSorter.reset();
            if (sorting == OxygenSorterGUIElement.EnumSorting.DOWN) {
                this.sortPlayers(0);
            } else {
                this.sortPlayers(1);
            }
        });
        this.usernameSorter = new OxygenSorterGUIElement(19, 27, OxygenSorterGUIElement.EnumSorting.INACTIVE, ClientReference.localize((String)"oxygen.sorting.username", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.usernameSorter);
        this.usernameSorter.setClickListener(sorting -> {
            this.statusSorter.reset();
            if (sorting == OxygenSorterGUIElement.EnumSorting.DOWN) {
                this.sortPlayers(2);
            } else {
                this.sortPlayers(3);
            }
        });
        this.playersPanel = new OxygenGUIButtonPanel((AbstractGUIScreen)this.screen, 6, 32, this.getWidth() - 15, 10, 1, MathUtils.clamp((int)OxygenHelperClient.getMaxPlayers(), (int)15, (int)1000), 15, GUISettings.get().getPanelTextScale(), true);
        this.addElement((GUIBaseElement)this.playersPanel);
        this.searchField = new OxygenGUITextField(90, 16, 60, 8, 24, "...", 3, false, -1L);
        this.addElement((GUIBaseElement)this.searchField);
        this.playersPanel.initSearchField((GUITextField)this.searchField);
        List actions = OxygenManagerClient.instance().getGUIManager().getContextActions(50);
        OxygenGUIContextMenuElement.ContextMenuAction[] array = new OxygenGUIContextMenuElement.ContextMenuAction[actions.size()];
        actions.toArray(array);
        this.playersPanel.initContextMenu((GUIContextMenu)new OxygenGUIContextMenu(GUISettings.get().getContextMenuWidth(), 9, array));
        this.activityStatusDDList = new ActivityStatusGUIDDList(7, 16);
        this.addElement((GUIBaseElement)this.activityStatusDDList);
        this.activityStatusDDList.setActivityStatusChangeListener(status -> {
            this.statusSorter.setSorting(OxygenSorterGUIElement.EnumSorting.DOWN);
            this.usernameSorter.reset();
            this.sortPlayers(0);
        });
    }

    private void sortPlayers(int mode) {
        List players = OxygenHelperClient.getPlayersSharedData().stream().filter(s -> OxygenHelperClient.isPlayerOnline((UUID)s.getPlayerUUID()) && (PlayersListGUISection.isClientPlayer(s) || OxygenHelperClient.getPlayerActivityStatus((PlayerSharedData)s) != OxygenPlayerData.EnumActivityStatus.OFFLINE || PrivilegeProviderClient.getValue((String)EnumOxygenPrivilege.EXPOSE_PLAYERS_OFFLINE.toString(), (boolean)false))).collect(Collectors.toList());
        if (mode == 0) {
            Collections.sort(players, (s1, s2) -> OxygenHelperClient.getPlayerActivityStatus((PlayerSharedData)s1).ordinal() - OxygenHelperClient.getPlayerActivityStatus((PlayerSharedData)s2).ordinal());
        } else if (mode == 1) {
            Collections.sort(players, (s1, s2) -> OxygenHelperClient.getPlayerActivityStatus((PlayerSharedData)s2).ordinal() - OxygenHelperClient.getPlayerActivityStatus((PlayerSharedData)s1).ordinal());
        } else if (mode == 2) {
            Collections.sort(players, (s1, s2) -> s1.getUsername().compareTo(s2.getUsername()));
        } else if (mode == 3) {
            Collections.sort(players, (s1, s2) -> s2.getUsername().compareTo(s1.getUsername()));
        }
        this.playersPanel.reset();
        for (PlayerSharedData sharedData : players) {
            this.playersPanel.addButton((GUIButton)new PlayersListEntryGUIButton(sharedData));
        }
        this.playersPanel.getScroller().resetPosition();
        this.playersPanel.getScroller().getSlider().reset();
        this.playersPanel.getScroller().updateRowsAmount(MathUtils.clamp((int)players.size(), (int)15, (int)OxygenHelperClient.getMaxPlayers()));
        this.searchField.reset();
        this.playersOnlineTextLabel.setDisplayText(String.valueOf(players.size()) + "/" + String.valueOf(OxygenHelperClient.getMaxPlayers()));
        this.playersOnlineTextLabel.setX(this.getWidth() - 6 - this.textWidth(this.playersOnlineTextLabel.getDisplayText(), GUISettings.get().getSubTextScale() - 0.05f));
    }

    private static boolean isClientPlayer(PlayerSharedData sharedData) {
        return sharedData.getPlayerUUID().equals(OxygenHelperClient.getPlayerUUID());
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        if (!this.searchField.isDragged() && !this.hasCurrentCallback()) {
            if (OxygenGUIHelper.isOxygenMenuEnabled()) {
                if (keyCode == PlayersListGUIScreen.PLAYERS_LIST_MENU_ENTRY.getIndex() + 2) {
                    this.screen.close();
                }
            } else if (keyCode == PlayersListKeyHandler.PLAYERS_LIST.func_151463_i()) {
                this.screen.close();
            }
        }
        return super.keyTyped(typedChar, keyCode);
    }

    public void sharedDataSynchronized() {
        this.activityStatusDDList.updateActivityStatus();
        this.sortPlayers(0);
    }
}

