/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_playerslist.common.core;

import austeretony.oxygen_playerslist.common.core.EnumInputClass;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class PlayersListClassTransformer
implements IClassTransformer {
    public static final Logger CORE_LOGGER = LogManager.getLogger((String)"Players List Core Plugin");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        switch (transformedName) {
            case "net.minecraft.client.gui.GuiIngame": {
                return this.patch(basicClass, EnumInputClass.MC_GUI_INGAME);
            }
            case "net.minecraftforge.client.GuiIngameForge": {
                return this.patch(basicClass, EnumInputClass.MC_GUI_INGAME_FORGE);
            }
        }
        return basicClass;
    }

    private byte[] patch(byte[] basicClass, EnumInputClass enumInput) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, enumInput.readerFlags);
        if (enumInput.patch(classNode)) {
            CORE_LOGGER.info("{} <{}.class> patched!", (Object)enumInput.domain, (Object)enumInput.clazz);
        } else {
            CORE_LOGGER.info("{} <{}.class> patch SKIPPED!", (Object)enumInput.domain, (Object)enumInput.clazz);
        }
        ClassWriter writer = new ClassWriter(enumInput.writerFlags);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

