/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.api.impl.grammar;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.grammar.GrammarGenerator;
import com.xcompwiz.mystcraft.grammar.GrammarTree;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ResourceLocation;

public class GrammarAPIDelegate {
    public void registerGrammarRule(ResourceLocation parent, Integer rank, ResourceLocation ... args) {
        ArrayList<ResourceLocation> list = CollectionUtils.buildList(args);
        GrammarGenerator.registerRule(new GrammarGenerator.Rule(parent, list, rank));
    }

    public Collection<IAgeSymbol> getSymbolsExpandingToken(ResourceLocation token) {
        ArrayList<GrammarGenerator.Rule> rules = new ArrayList<GrammarGenerator.Rule>();
        List<GrammarGenerator.Rule> tokenrules = GrammarGenerator.getAllRules(token);
        if (tokenrules != null) {
            rules.addAll(tokenrules);
        }
        HashSet<IAgeSymbol> symbols = new HashSet<IAgeSymbol>();
        for (GrammarGenerator.Rule rule : rules) {
            for (ResourceLocation rule_token : rule.getValues()) {
                IAgeSymbol symbol2;
                if (!SymbolManager.hasBinding(rule_token) || (symbol2 = SymbolManager.getAgeSymbol(rule_token)) == null) continue;
                symbols.add(symbol2);
            }
        }
        return symbols;
    }

    public Collection<ResourceLocation> getTokensProducingToken(ResourceLocation token) {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        List<GrammarGenerator.Rule> rules = GrammarGenerator.getParentRules(token);
        for (GrammarGenerator.Rule rule : rules) {
            set.add(rule.getParent());
        }
        return set;
    }

    public List<ResourceLocation> generateFromToken(ResourceLocation root, Random rand) {
        GrammarTree tree = new GrammarTree(root);
        return tree.getExpanded(rand);
    }

    public List<ResourceLocation> generateFromToken(ResourceLocation root, Random rand, List<ResourceLocation> parsed) {
        GrammarTree tree = new GrammarTree(root);
        tree.parseTerminals(parsed, rand);
        return tree.getExpanded(rand);
    }
}

