/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.block;

import com.google.common.collect.Lists;
import com.xcompwiz.mystcraft.instability.decay.DecayHandler;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDecay
extends Block {
    public static final PropertyEnum<DecayHandler.DecayType> DECAY_META = PropertyEnum.func_177709_a((String)"decay", DecayHandler.DecayType.class);

    public BlockDecay() {
        super(Material.field_151595_p);
        this.func_149675_a(false);
        this.func_149672_a(SoundType.field_185855_h);
        this.func_149663_c("myst.unstable");
    }

    public IBlockState func_176203_a(int meta) {
        if (meta >= DecayHandler.DecayType.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(DECAY_META, (Comparable)((Object)DecayHandler.DecayType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((DecayHandler.DecayType)((Object)state.func_177229_b(DECAY_META))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DECAY_META});
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176206_d(worldIn, pos, state);
        this.getDecayHandler((DecayHandler.DecayType)((Object)state.func_177229_b(DECAY_META))).onBlockDestroyedByPlayer(worldIn, pos);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.getDecayHandler((DecayHandler.DecayType)((Object)state.func_177229_b(DECAY_META))).updateTick(worldIn, pos, rand);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.getDecayHandler((DecayHandler.DecayType)((Object)state.func_177229_b(DECAY_META))).onBlockAdded(worldIn, pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Lists.newArrayList();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return this.getDecayHandler((DecayHandler.DecayType)((Object)world.func_180495_p(pos).func_177229_b(DECAY_META))).getExplosionResistance(world, pos, exploder, explosion);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.getDecayHandler((DecayHandler.DecayType)((Object)blockState.func_177229_b(DECAY_META))).getBlockHardness(worldIn, pos);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.field_149784_t;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.getDecayHandler((DecayHandler.DecayType)((Object)worldIn.func_180495_p(pos).func_177229_b(DECAY_META))).onEntityContact(worldIn, pos, entityIn);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        this.getDecayHandler((DecayHandler.DecayType)((Object)state.func_177229_b(DECAY_META))).onEntityContact(worldIn, pos, entityIn);
    }

    private DecayHandler getDecayHandler(DecayHandler.DecayType decayType) {
        DecayHandler handler = DecayHandler.getHandler(decayType);
        if (handler == null) {
            handler = DecayHandler.getHandler(DecayHandler.DecayType.BLACK);
        }
        return handler;
    }
}

