/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.effects;

import com.google.common.collect.Iterables;
import com.xcompwiz.mystcraft.api.world.logic.IEnvironmentalEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class EffectPotion
implements IEnvironmentalEffect {
    private int level;
    private boolean isGlobal;
    private Potion potion;
    private int duration;

    public EffectPotion(int level, Boolean global, Potion type, Integer duration) {
        this.level = level - 1;
        this.isGlobal = global;
        this.potion = type;
        this.duration = duration;
    }

    @Override
    public void tick(World worldObj, Chunk chunk) {
        int index;
        Entity entity;
        int i;
        ClassInheritanceMultiMap[] entityLists = chunk.func_177429_s();
        ClassInheritanceMultiMap list = entityLists[i = worldObj.field_73012_v.nextInt(entityLists.length)];
        if (list.size() > 0 && (entity = (Entity)Iterables.get((Iterable)list, (int)(index = worldObj.field_73012_v.nextInt(list.size())))) instanceof EntityLivingBase && this.isTargetValid(worldObj, entity)) {
            ((EntityLivingBase)entity).func_70690_d(this.getEffect());
        }
    }

    protected boolean isTargetValid(World worldObj, Entity entity) {
        return this.isGlobal || worldObj.func_175678_i(entity.func_180425_c());
    }

    protected PotionEffect getEffect() {
        return new PotionEffect(this.potion, this.duration, this.level);
    }
}

