/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.inventory;

import com.xcompwiz.mystcraft.inventory.ITargetInventory;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class SlotCollection
implements ITargetInventory {
    private int begin;
    private int end;
    private boolean reverse = false;
    private Container container;
    private LinkedList<ITargetInventory> targetList = new LinkedList();

    public SlotCollection(Container container, int begin, int end) {
        this.container = container;
        this.begin = begin;
        this.end = end;
    }

    public void pushTargetFront(ITargetInventory target) {
        this.targetList.add(0, target);
    }

    public boolean contains(int i) {
        if (i < this.begin) {
            return false;
        }
        return i < this.end;
    }

    public boolean onShiftClick(@Nonnull ItemStack original) {
        for (ITargetInventory target : this.targetList) {
            if (!target.merge(original)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean merge(@Nonnull ItemStack itemstack) {
        ItemStack destStack;
        Slot slot;
        boolean success = false;
        int slotId = this.begin;
        if (this.reverse) {
            slotId = this.end - 1;
        }
        if (itemstack.func_77985_e()) {
            while (itemstack.func_190916_E() > 0 && (!this.reverse && slotId < this.end || this.reverse && slotId >= this.begin)) {
                slot = (Slot)this.container.field_75151_b.get(slotId);
                destStack = slot.func_75211_c();
                if (!(destStack.func_190926_b() || destStack != itemstack || itemstack.func_77981_g() && itemstack.func_77952_i() != destStack.func_77952_i() || !ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)destStack))) {
                    int totalSize = destStack.func_190916_E() + itemstack.func_190916_E();
                    int maxdestsize = itemstack.func_77976_d();
                    if (slot.func_75219_a() < maxdestsize) {
                        maxdestsize = slot.func_75219_a();
                    }
                    if (totalSize <= maxdestsize) {
                        itemstack.func_190920_e(0);
                        destStack.func_190920_e(totalSize);
                        slot.func_75218_e();
                        success = true;
                    } else if (destStack.func_190916_E() < maxdestsize) {
                        itemstack.func_190918_g(maxdestsize - destStack.func_190916_E());
                        destStack.func_190920_e(maxdestsize);
                        slot.func_75218_e();
                        success = true;
                    }
                }
                if (this.reverse) {
                    --slotId;
                    continue;
                }
                ++slotId;
            }
        }
        if (itemstack.func_190916_E() > 0) {
            slotId = this.reverse ? this.end - 1 : this.begin;
            while ((!this.reverse && slotId < this.end || this.reverse && slotId >= this.begin) && itemstack.func_190916_E() > 0) {
                slot = (Slot)this.container.field_75151_b.get(slotId);
                destStack = slot.func_75211_c();
                if (destStack.func_190926_b() && slot.func_75214_a(itemstack)) {
                    ItemStack clone = itemstack.func_77946_l();
                    if (clone.func_190916_E() > slot.func_75219_a()) {
                        clone.func_190920_e(slot.func_75219_a());
                    }
                    slot.func_75215_d(clone);
                    slot.func_75218_e();
                    itemstack.func_190918_g(clone.func_190916_E());
                    success = true;
                }
                if (this.reverse) {
                    --slotId;
                    continue;
                }
                ++slotId;
            }
        }
        return success;
    }
}

