/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.item;

import com.xcompwiz.mystcraft.api.item.IItemPageAcceptor;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.core.MystcraftCommonProxy;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.mystcraft.treasure.WeightProviderSymbolItem;
import com.xcompwiz.mystcraft.utility.WeightedItemSelector;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemBoosterPack
extends Item {
    public ItemBoosterPack() {
        this.func_77655_b("myst.booster");
        this.func_77637_a(MystcraftCommonProxy.tabMystCommon);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return EnumActionResult.PASS;
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack held = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)held);
        }
        ItemStack newBooster = ItemBoosterPack.generateBooster(ItemStack.field_190927_a, playerIn.func_70681_au(), 7, 4, 4, 1);
        if (newBooster.func_190926_b()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)held);
        }
        held.func_190918_g(1);
        if (held.func_190926_b()) {
            playerIn.func_184611_a(handIn, ItemStack.field_190927_a);
            held = newBooster;
        } else if (!playerIn.field_71071_by.func_70441_a(newBooster)) {
            held.func_190917_f(1);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)held);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)held);
    }

    @Nonnull
    public static ItemStack generateBooster(@Nonnull ItemStack itemstack, Random rand, int verycommon, int common, int uncommon, int rare) {
        if (itemstack.func_190926_b()) {
            itemstack = new ItemStack(ModItems.folder, 1, 0);
        }
        IItemPageAcceptor item = (IItemPageAcceptor)itemstack.func_77973_b();
        Collection<IAgeSymbol> symbols_vc = SymbolManager.getSymbolsByRank(0);
        Collection<IAgeSymbol> symbols_c = SymbolManager.getSymbolsByRank(1);
        Collection<IAgeSymbol> symbols_uc = SymbolManager.getSymbolsByRank(2);
        Collection<IAgeSymbol> symbols_r = SymbolManager.getSymbolsByRank(3, null);
        ItemBoosterPack.addRandomPages(rand, item, itemstack, verycommon, symbols_vc);
        ItemBoosterPack.addRandomPages(rand, item, itemstack, common, symbols_c);
        ItemBoosterPack.addRandomPages(rand, item, itemstack, uncommon, symbols_uc);
        ItemBoosterPack.addRandomPages(rand, item, itemstack, rare, symbols_r);
        return itemstack;
    }

    private static void addRandomPages(Random rand, IItemPageAcceptor item, @Nonnull ItemStack itemstack, int count, Collection<IAgeSymbol> collection) {
        for (int i = 0; i < count; ++i) {
            IAgeSymbol symbol2 = WeightedItemSelector.getRandomItem(rand, collection, WeightProviderSymbolItem.instance);
            if (ItemBoosterPack.checker(symbol2, collection)) continue;
            item.addPage(null, itemstack, Page.createSymbolPage(symbol2.getRegistryName()));
        }
    }

    private static boolean checker(IAgeSymbol symbol2, Collection<IAgeSymbol> collection) {
        if (symbol2 == null) {
            LoggerUtils.error("Symbol from random selection null (%s)", collection.toString());
            return true;
        }
        return false;
    }
}

