/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.portal;

import com.xcompwiz.mystcraft.block.BlockBookReceptacle;
import com.xcompwiz.mystcraft.block.BlockCrystal;
import com.xcompwiz.mystcraft.block.BlockLinkPortal;
import com.xcompwiz.mystcraft.data.ModBlocks;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class PortalUtils {
    public static Block getPortalBlock() {
        return ModBlocks.portal;
    }

    public static Block getFrameBlock() {
        return ModBlocks.crystal;
    }

    public static Block getReceptacleBlock() {
        return ModBlocks.receptacle;
    }

    public static int isValidLinkPortalBlock(IBlockState blockstate) {
        if (blockstate.func_177230_c() == PortalUtils.getFrameBlock()) {
            return 1;
        }
        if (blockstate.func_177230_c() == PortalUtils.getPortalBlock()) {
            return 1;
        }
        return 0;
    }

    private static EnumFacing getBlockFacing(IBlockState blockstate) {
        if (blockstate.func_177230_c() == PortalUtils.getFrameBlock()) {
            return (EnumFacing)blockstate.func_177229_b(BlockCrystal.SOURCE_DIRECTION);
        }
        if (blockstate.func_177230_c() == PortalUtils.getPortalBlock()) {
            return (EnumFacing)blockstate.func_177229_b(BlockLinkPortal.SOURCE_DIRECTION);
        }
        if (blockstate.func_177230_c() == PortalUtils.getReceptacleBlock()) {
            return (EnumFacing)blockstate.func_177229_b(BlockBookReceptacle.ROTATION);
        }
        return EnumFacing.DOWN;
    }

    private static boolean isBlockActive(IBlockState blockstate) {
        if (blockstate.func_177230_c() == PortalUtils.getFrameBlock()) {
            return (Boolean)blockstate.func_177229_b((IProperty)BlockCrystal.IS_PART_OF_PORTAL);
        }
        if (blockstate.func_177230_c() == PortalUtils.getPortalBlock()) {
            return (Boolean)blockstate.func_177229_b((IProperty)BlockLinkPortal.IS_PART_OF_PORTAL);
        }
        return false;
    }

    private static IBlockState getDirectedState(IBlockState blockstate, int m) {
        if (blockstate.func_177230_c() == PortalUtils.getFrameBlock()) {
            return blockstate.func_177226_a((IProperty)BlockCrystal.IS_PART_OF_PORTAL, (Comparable)Boolean.valueOf(true)).func_177226_a(BlockCrystal.SOURCE_DIRECTION, (Comparable)EnumFacing.values()[m]);
        }
        if (blockstate.func_177230_c() == PortalUtils.getPortalBlock()) {
            return blockstate.func_177226_a((IProperty)BlockLinkPortal.IS_PART_OF_PORTAL, (Comparable)Boolean.valueOf(true)).func_177226_a(BlockLinkPortal.SOURCE_DIRECTION, (Comparable)EnumFacing.values()[m]);
        }
        return blockstate;
    }

    private static IBlockState getDisabledState(IBlockState blockstate) {
        if (blockstate.func_177230_c() == PortalUtils.getFrameBlock()) {
            return blockstate.func_177226_a((IProperty)BlockCrystal.IS_PART_OF_PORTAL, (Comparable)Boolean.valueOf(false));
        }
        if (blockstate.func_177230_c() == PortalUtils.getPortalBlock()) {
            return blockstate.func_177226_a((IProperty)BlockLinkPortal.IS_PART_OF_PORTAL, (Comparable)Boolean.valueOf(false));
        }
        return blockstate;
    }

    public static void validatePortal(World world, BlockPos start) {
        if (world.field_72995_K) {
            return;
        }
        LinkedList<BlockPos> blocks = new LinkedList<BlockPos>();
        blocks.add(start);
        while (blocks.size() > 0) {
            BlockPos coords = (BlockPos)blocks.remove(0);
            if (world.func_180495_p(coords).func_177230_c() != PortalUtils.getPortalBlock()) continue;
            PortalUtils.validatePortal(world, coords, blocks);
        }
    }

    public static void firePortal(World world, BlockPos pos) {
        BlockPos coord = PortalUtils.getReceptacleBase(pos, PortalUtils.getBlockFacing(world.func_180495_p(pos)));
        PortalUtils.onpulse(world, coord);
        PortalUtils.pathto(world, pos);
    }

    public static void shutdownPortal(World world, BlockPos pos) {
        PortalUtils.unpath(world, pos);
    }

    public static BlockPos getReceptacleBase(BlockPos pos, EnumFacing facing) {
        return pos.func_177972_a(facing.func_176734_d());
    }

    private static void pathto(World world, BlockPos pos) {
        BlockPos coords;
        LinkedList<BlockPos> blocks = new LinkedList<BlockPos>();
        LinkedList<BlockPos> portals = new LinkedList<BlockPos>();
        LinkedList<BlockPos> repath = new LinkedList<BlockPos>();
        LinkedList<BlockPos> redraw = new LinkedList<BlockPos>();
        blocks.add(pos);
        while (portals.size() > 0 || blocks.size() > 0) {
            while (blocks.size() > 0) {
                coords = (BlockPos)blocks.remove(0);
                PortalUtils.directPortal(world, coords.func_177974_f(), 5, blocks, portals);
                PortalUtils.directPortal(world, coords.func_177984_a(), 1, blocks, portals);
                PortalUtils.directPortal(world, coords.func_177968_d(), 3, blocks, portals);
                PortalUtils.directPortal(world, coords.func_177976_e(), 6, blocks, portals);
                PortalUtils.directPortal(world, coords.func_177977_b(), 2, blocks, portals);
                PortalUtils.directPortal(world, coords.func_177978_c(), 4, blocks, portals);
                redraw.add(coords);
            }
            if (portals.size() <= 0) continue;
            coords = (BlockPos)portals.remove(0);
            PortalUtils.directPortal(world, coords.func_177974_f(), 5, blocks, portals);
            PortalUtils.directPortal(world, coords.func_177984_a(), 1, blocks, portals);
            PortalUtils.directPortal(world, coords.func_177968_d(), 3, blocks, portals);
            PortalUtils.directPortal(world, coords.func_177976_e(), 6, blocks, portals);
            PortalUtils.directPortal(world, coords.func_177977_b(), 2, blocks, portals);
            PortalUtils.directPortal(world, coords.func_177978_c(), 4, blocks, portals);
            if (world.func_180495_p(coords).func_177230_c() != PortalUtils.getPortalBlock()) continue;
            repath.add(coords);
        }
        while (repath.size() > 0) {
            coords = (BlockPos)repath.remove(0);
            if (world.func_180495_p(coords).func_177230_c() != PortalUtils.getPortalBlock()) continue;
            if (!PortalUtils.isPortalBlockStable(world, coords)) {
                PortalUtils.repathNeighbors(world, coords);
                world.func_180501_a(coords, Blocks.field_150350_a.func_176223_P(), 0);
                PortalUtils.addSurrounding(repath, coords);
                continue;
            }
            redraw.add(coords);
        }
        for (BlockPos coords2 : redraw) {
            if (!world.func_190526_b(coords2.func_177958_n() >> 4, coords2.func_177952_p() >> 4)) continue;
            IBlockState blockState = world.func_180495_p(coords2);
            world.func_184138_a(coords2, blockState, blockState, 3);
        }
    }

    private static void repathNeighbors(World world, BlockPos pos) {
        TileEntity tileentity = PortalUtils.getTileEntity((IBlockAccess)world, pos);
        LinkedList<BlockPos> blocks = new LinkedList<BlockPos>();
        blocks.add(pos);
        world.func_180501_a(pos, PortalUtils.getDisabledState(world.func_180495_p(pos)), 2);
        while (blocks.size() > 0) {
            BlockPos coords = (BlockPos)blocks.remove(0);
            PortalUtils.redirectPortal(world, tileentity, coords.func_177974_f(), 5, blocks);
            PortalUtils.redirectPortal(world, tileentity, coords.func_177984_a(), 1, blocks);
            PortalUtils.redirectPortal(world, tileentity, coords.func_177968_d(), 3, blocks);
            PortalUtils.redirectPortal(world, tileentity, coords.func_177976_e(), 6, blocks);
            PortalUtils.redirectPortal(world, tileentity, coords.func_177977_b(), 2, blocks);
            PortalUtils.redirectPortal(world, tileentity, coords.func_177978_c(), 4, blocks);
        }
    }

    private static void redirectPortal(World world, TileEntity tileentity, BlockPos pos, int meta, List<BlockPos> blocks) {
        IBlockState blockstate = world.func_180495_p(pos);
        if (PortalUtils.isValidLinkPortalBlock(blockstate) == 0) {
            return;
        }
        if (PortalUtils.isBlockActive(blockstate) && PortalUtils.getBlockFacing(blockstate).ordinal() + 1 == meta) {
            for (int m = 1; m < 7; ++m) {
                if (m == meta) continue;
                world.func_180501_a(pos, PortalUtils.getDirectedState(blockstate, m - 1), 2);
                TileEntity local = PortalUtils.getTileEntity((IBlockAccess)world, pos);
                if (local != tileentity && (local == null || tileentity != null)) continue;
                return;
            }
            world.func_180501_a(pos, blockstate.func_177230_c().func_176223_P(), 2);
        }
    }

    private static void unpath(World world, BlockPos pos) {
        LinkedList<BlockPos> blocks = new LinkedList<BlockPos>();
        LinkedList<BlockPos> notify = new LinkedList<BlockPos>();
        blocks.add(pos);
        while (blocks.size() > 0) {
            BlockPos coords = (BlockPos)blocks.remove(0);
            PortalUtils.depolarize(world, coords.func_177974_f(), blocks);
            PortalUtils.depolarize(world, coords.func_177984_a(), blocks);
            PortalUtils.depolarize(world, coords.func_177968_d(), blocks);
            PortalUtils.depolarize(world, coords.func_177976_e(), blocks);
            PortalUtils.depolarize(world, coords.func_177977_b(), blocks);
            PortalUtils.depolarize(world, coords.func_177978_c(), blocks);
            notify.add(coords);
        }
        for (BlockPos coords : notify) {
            if (!world.func_190526_b(coords.func_177958_n() >> 4, coords.func_177952_p() >> 4)) continue;
            IBlockState blockState = world.func_180495_p(coords);
            world.func_184138_a(coords, blockState, blockState, 3);
        }
    }

    private static void onpulse(World world, BlockPos pos) {
        BlockPos coords;
        LinkedList<BlockPos> set = new LinkedList<BlockPos>();
        Stack<BlockPos> validate = new Stack<BlockPos>();
        PortalUtils.addSurrounding(set, pos);
        while (set.size() > 0) {
            coords = set.remove(0);
            PortalUtils.expandPortal(world, coords, set, validate);
        }
        while (validate.size() > 0) {
            coords = (BlockPos)validate.pop();
            if (PortalUtils.checkPortalTension(world, coords)) continue;
            world.func_180501_a(coords, Blocks.field_150350_a.func_176223_P(), 0);
        }
    }

    private static boolean isPortalBlockStable(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return true;
        }
        if (!PortalUtils.checkPortalTension(world, pos)) {
            return false;
        }
        return PortalUtils.getTileEntity((IBlockAccess)world, pos) != null;
    }

    private static boolean checkPortalTension(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return true;
        }
        int score = 0;
        if (PortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177974_f())) > 0 && PortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177976_e())) > 0) {
            ++score;
        }
        if (PortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177984_a())) > 0 && PortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177977_b())) > 0) {
            ++score;
        }
        if (PortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177968_d())) > 0 && PortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177978_c())) > 0) {
            ++score;
        }
        return score > 1;
    }

    private static void validatePortal(World world, BlockPos pos, Collection<BlockPos> blocks) {
        if (!PortalUtils.isPortalBlockStable(world, pos)) {
            world.func_175698_g(pos);
            PortalUtils.addSurrounding(blocks, pos);
        }
    }

    private static void addSurrounding(Collection<BlockPos> set, BlockPos pos) {
        set.add(new BlockPos((Vec3i)pos.func_177974_f()));
        set.add(new BlockPos((Vec3i)pos.func_177976_e()));
        set.add(new BlockPos((Vec3i)pos.func_177984_a()));
        set.add(new BlockPos((Vec3i)pos.func_177977_b()));
        set.add(new BlockPos((Vec3i)pos.func_177968_d()));
        set.add(new BlockPos((Vec3i)pos.func_177978_c()));
        set.add(new BlockPos((Vec3i)pos.func_177974_f().func_177984_a()));
        set.add(new BlockPos((Vec3i)pos.func_177976_e().func_177984_a()));
        set.add(new BlockPos((Vec3i)pos.func_177974_f().func_177977_b()));
        set.add(new BlockPos((Vec3i)pos.func_177976_e().func_177977_b()));
        set.add(new BlockPos((Vec3i)pos.func_177968_d().func_177984_a()));
        set.add(new BlockPos((Vec3i)pos.func_177978_c().func_177984_a()));
        set.add(new BlockPos((Vec3i)pos.func_177968_d().func_177977_b()));
        set.add(new BlockPos((Vec3i)pos.func_177978_c().func_177977_b()));
        set.add(new BlockPos((Vec3i)pos.func_177974_f().func_177968_d()));
        set.add(new BlockPos((Vec3i)pos.func_177976_e().func_177968_d()));
        set.add(new BlockPos((Vec3i)pos.func_177974_f().func_177978_c()));
        set.add(new BlockPos((Vec3i)pos.func_177976_e().func_177978_c()));
    }

    private static void expandPortal(World world, BlockPos pos, Collection<BlockPos> set, Stack<BlockPos> created) {
        if (!world.func_175623_d(pos)) {
            return;
        }
        int score = PortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177974_f())) + PortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177976_e())) + PortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177984_a())) + PortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177977_b())) + PortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177968_d())) + PortalUtils.isValidLinkPortalBlock(world.func_180495_p(pos.func_177978_c()));
        if (score > 1) {
            world.func_180501_a(pos, PortalUtils.getPortalBlock().func_176223_P(), 0);
            created.push(pos);
            PortalUtils.addSurrounding(set, pos);
        }
    }

    private static void directPortal(World world, BlockPos pos, int meta, List<BlockPos> blocks, List<BlockPos> portals) {
        IBlockState blockState = world.func_180495_p(pos);
        if (PortalUtils.isValidLinkPortalBlock(blockState) == 0) {
            return;
        }
        if (PortalUtils.isBlockActive(blockState)) {
            return;
        }
        world.func_180501_a(pos, PortalUtils.getDirectedState(blockState, meta - 1), 0);
        if (blockState.func_177230_c() == PortalUtils.getPortalBlock()) {
            portals.add(pos);
        } else {
            blocks.add(pos);
        }
    }

    private static void depolarize(World world, BlockPos pos, List<BlockPos> blocks) {
        IBlockState blockstate = world.func_180495_p(pos);
        if (PortalUtils.isValidLinkPortalBlock(blockstate) == 0) {
            return;
        }
        if (!PortalUtils.isBlockActive(blockstate)) {
            return;
        }
        world.func_180501_a(pos, blockstate.func_177230_c().func_176223_P(), 0);
        if (blockstate.func_177230_c() == PortalUtils.getPortalBlock() && !PortalUtils.isPortalBlockStable(world, pos)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
        blocks.add(pos);
    }

    public static TileEntity getTileEntity(IBlockAccess blockaccess, BlockPos pos) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        IBlockState blockstate = blockaccess.func_180495_p(pos);
        while (blockstate.func_177230_c() != PortalUtils.getReceptacleBlock()) {
            if (PortalUtils.isValidLinkPortalBlock(blockstate) == 0) {
                return null;
            }
            if (!PortalUtils.isBlockActive(blockstate)) {
                return null;
            }
            if (!visited.add(pos)) {
                return null;
            }
            pos = pos.func_177972_a(PortalUtils.getBlockFacing(blockstate));
            blockstate = blockaccess.func_180495_p(pos);
        }
        return blockaccess.func_175625_s(pos);
    }
}

