/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.BlockCategory;
import com.xcompwiz.mystcraft.api.symbol.BlockDescriptor;
import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainGenerator;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.ChunkPrimer;

public class SymbolTerrainGenFlat
extends SymbolBase {
    public SymbolTerrainGenFlat(ResourceLocation identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        TerrainGenerator gen = new TerrainGenerator(controller);
        BlockDescriptor block = ModifierUtils.popBlockMatching(controller, BlockCategory.SEA);
        if (block != null) {
            gen.setSeaBlock(block.blockstate);
        }
        if ((block = ModifierUtils.popBlockMatching(controller, BlockCategory.TERRAIN)) != null) {
            gen.setTerrainBlock(block.blockstate);
        }
        controller.registerInterface(gen);
    }

    @Override
    public boolean generatesConfigOption() {
        return true;
    }

    private static class TerrainGenerator
    implements ITerrainGenerator {
        private AgeDirector controller;
        private IBlockState fillblock = Blocks.field_150348_b.func_176223_P();
        private IBlockState seablock = Blocks.field_150355_j.func_176223_P();

        public TerrainGenerator(AgeDirector controller) {
            this.controller = controller;
        }

        public void setTerrainBlock(IBlockState state) {
            this.fillblock = state;
        }

        public void setSeaBlock(IBlockState state) {
            this.seablock = state;
        }

        @Override
        public void generateTerrain(int chunkX, int chunkZ, ChunkPrimer primer) {
            int plane = this.controller.getAverageGroundLevel();
            int sealevel = this.controller.getSeaLevel();
            int layers = 256;
            for (int y = 0; y < layers; ++y) {
                IBlockState blockId = Blocks.field_150350_a.func_176223_P();
                if (y == 0) {
                    blockId = Blocks.field_150357_h.func_176223_P();
                } else if (y < plane) {
                    blockId = this.fillblock;
                } else if (y <= sealevel) {
                    blockId = this.seablock;
                }
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        primer.func_177855_a(x, y, z, blockId);
                    }
                }
            }
        }
    }
}

