/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world;

import com.xcompwiz.mystcraft.world.AgeController;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.IntCache;

public class BiomeProviderMyst
extends BiomeProvider {
    private AgeController controller;

    public BiomeProviderMyst(AgeController c) {
        this.controller = c;
    }

    public List<Biome> func_76932_a() {
        return this.controller.getBiomeController().getValidSpawnBiomes();
    }

    public Biome func_180631_a(BlockPos pos) {
        return this.func_180300_a(pos, Biomes.field_76772_c);
    }

    public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
        Biome biome = this.controller.getBiomeController().getBiomeAtCoords(pos.func_177958_n(), pos.func_177952_p());
        this.controller.modifyBiomeAt(biome, pos.func_177958_n(), pos.func_177952_p());
        return biome;
    }

    public Biome[] func_76937_a(Biome[] aBiome, int x, int z, int xSize, int zSize) {
        IntCache.func_76446_a();
        if (aBiome == null || aBiome.length < xSize * zSize) {
            aBiome = new Biome[xSize * zSize];
        }
        aBiome = this.controller.getBiomeController().getBiomesForGeneration(aBiome, x, z, xSize, zSize);
        this.controller.modifyGenerationBiomesAt(aBiome, x, z, xSize, zSize);
        return aBiome;
    }

    public Biome[] func_76933_b(@Nullable Biome[] oldBiomeList, int x, int z, int width, int depth) {
        return this.func_76931_a(oldBiomeList, x, z, width, depth, true);
    }

    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new Biome[width * length];
        }
        listToReuse = this.controller.getBiomeController().getBiomesAtCoords(listToReuse, x, z, width, length, cacheFlag);
        this.controller.modifyBiomesAt(listToReuse, x, z, width, length, cacheFlag);
        return listToReuse;
    }

    public float func_76939_a(float temp, int y) {
        return this.controller.getTemperatureAtHeight(temp, y);
    }

    public boolean func_76940_a(int i, int j, int k, List<Biome> list) {
        int l = i - k >> 2;
        int i1 = j - k >> 2;
        int j1 = i + k >> 2;
        int k1 = j + k >> 2;
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        Biome[] biomes = this.func_76937_a(null, l, i1, l1, i2);
        for (int j2 = 0; j2 < l1 * i2; ++j2) {
            if (list.contains(biomes[j2])) continue;
            return false;
        }
        return true;
    }

    public BlockPos func_180630_a(int i, int j, int k, List<Biome> list, Random random) {
        int l = i - k >> 2;
        int i1 = j - k >> 2;
        int j1 = i + k >> 2;
        int k1 = j + k >> 2;
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        Biome[] biomes = this.func_76937_a(null, l, i1, l1, i2);
        BlockPos blockpos = null;
        int j2 = 0;
        for (int k2 = 0; k2 < 256; ++k2) {
            int l2 = l + k2 % l1 << 2;
            int i3 = i1 + k2 / l1 << 2;
            if (!list.contains(biomes[k2]) || blockpos != null && random.nextInt(j2 + 1) != 0) continue;
            blockpos = new BlockPos(l2, 0, i3);
            ++j2;
        }
        return blockpos;
    }

    public void func_76938_b() {
        this.controller.getBiomeController().cleanupCache();
    }
}

