/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.gen;

import com.xcompwiz.mystcraft.world.gen.MapGenAdvanced;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class MapGenCavesMyst
extends MapGenAdvanced {
    private int rate = 15;
    private int size = 40;

    public MapGenCavesMyst(long seed, int rate, int size, Block block) {
        this(seed, rate, size, block.func_176223_P());
    }

    public MapGenCavesMyst(long seed, int rate, int size, IBlockState block) {
        super(seed, block);
        this.rate = rate;
        this.size = size;
    }

    protected void generateLargeCaveNode(long seed, int chunkX, int chunkZ, ChunkPrimer primer, double baseX, double baseY, double baseZ) {
        this.generateCaveNode(seed, chunkX, chunkZ, primer, baseX, baseY, baseZ, 1.0f + this.rand.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5);
    }

    protected void generateCaveNode(long seed, int chunkX, int chunkZ, ChunkPrimer primer, double baseX, double baseY, double baseZ, float par12, float par13, float par14, int par15, int par16, double par17) {
        boolean flag1;
        double chunkXmid = chunkX * 16 + 8;
        double chunkZmid = chunkZ * 16 + 8;
        int layers = 256;
        float f = 0.0f;
        float f1 = 0.0f;
        Random random = new Random(seed);
        if (par16 <= 0) {
            int i = this.range * 16 - 16;
            par16 = i - random.nextInt(i / 4);
        }
        boolean flag = false;
        if (par15 == -1) {
            par15 = par16 / 2;
            flag = true;
        }
        int j = random.nextInt(par16 / 2) + par16 / 4;
        boolean bl = flag1 = random.nextInt(6) == 0;
        while (par15 < par16) {
            double d2 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)par15 * (float)Math.PI / (float)par16)) * par12 * 1.0f);
            double d3 = d2 * par17;
            float f2 = MathHelper.func_76134_b((float)par14);
            float f3 = MathHelper.func_76126_a((float)par14);
            baseX += (double)(MathHelper.func_76134_b((float)par13) * f2);
            baseY += (double)f3;
            baseZ += (double)(MathHelper.func_76126_a((float)par13) * f2);
            par14 = flag1 ? (par14 *= 0.92f) : (par14 *= 0.7f);
            par14 += f1 * 0.1f;
            par13 += f * 0.1f;
            f1 *= 0.9f;
            f *= 0.75f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!flag && par15 == j && par12 > 1.0f && par16 > 0) {
                this.generateCaveNode(random.nextLong(), chunkX, chunkZ, primer, baseX, baseY, baseZ, random.nextFloat() * 0.5f + 0.5f, par13 - 1.5707964f, par14 / 3.0f, par15, par16, 1.0);
                this.generateCaveNode(random.nextLong(), chunkX, chunkZ, primer, baseX, baseY, baseZ, random.nextFloat() * 0.5f + 0.5f, par13 + 1.5707964f, par14 / 3.0f, par15, par16, 1.0);
                return;
            }
            if (flag || random.nextInt(4) != 0) {
                double xoffset = baseX - chunkXmid;
                double yoffset = baseZ - chunkZmid;
                double zoffset = par16 - par15;
                double d7 = par12 + 2.0f + 16.0f;
                if (xoffset * xoffset + yoffset * yoffset - zoffset * zoffset > d7 * d7) {
                    return;
                }
                if (!(baseX < chunkXmid - 16.0 - d2 * 2.0 || baseZ < chunkZmid - 16.0 - d2 * 2.0 || baseX > chunkXmid + 16.0 + d2 * 2.0 || baseZ > chunkZmid + 16.0 + d2 * 2.0)) {
                    int minX = MathHelper.func_76128_c((double)(baseX - d2)) - chunkX * 16 - 1;
                    int maxX = MathHelper.func_76128_c((double)(baseX + d2)) - chunkX * 16 + 1;
                    int minY = MathHelper.func_76128_c((double)(baseY - d3)) - 1;
                    int maxY = MathHelper.func_76128_c((double)(baseY + d3)) + 1;
                    int minZ = MathHelper.func_76128_c((double)(baseZ - d2)) - chunkZ * 16 - 1;
                    int maxZ = MathHelper.func_76128_c((double)(baseZ + d2)) - chunkZ * 16 + 1;
                    if (minX < 0) {
                        minX = 0;
                    }
                    if (maxX > 16) {
                        maxX = 16;
                    }
                    if (minY < 1) {
                        minY = 1;
                    }
                    if (maxY > layers) {
                        maxY = layers;
                    }
                    if (minZ < 0) {
                        minZ = 0;
                    }
                    if (maxZ > 16) {
                        maxZ = 16;
                    }
                    for (int localY = minY; localY < maxY; ++localY) {
                        double yfactor = ((double)localY + 0.5 - baseY) / d3;
                        double yfactorSq = yfactor * yfactor;
                        for (int localZ = minZ; localZ < maxZ; ++localZ) {
                            double zfactor = ((double)(localZ + chunkZ * 16) + 0.5 - baseZ) / d2;
                            double zfactorSq = zfactor * zfactor;
                            for (int localX = minX; localX < maxX; ++localX) {
                                double xfactor = ((double)(localX + chunkX * 16) + 0.5 - baseX) / d2;
                                double xfactorSq = xfactor * xfactor;
                                if (!(xfactorSq + zfactorSq < 1.0) || !(yfactor > -0.7) || !(xfactorSq + yfactorSq + zfactorSq < 1.0)) continue;
                                this.placeBlock(primer, localX, localY, localZ);
                            }
                        }
                    }
                    if (flag) break;
                }
            }
            ++par15;
        }
    }

    @Override
    protected void recursiveGenerate(World worldObj, int x, int z, int chunkX, int chunkZ, ChunkPrimer primer) {
        int maxNodes = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(this.size) + 1) + 1);
        if (this.rand.nextInt(this.rate) != 0) {
            maxNodes = 0;
        }
        for (int j = 0; j < maxNodes; ++j) {
            double d = x * 16 + this.rand.nextInt(16);
            double d1 = this.rand.nextInt(this.rand.nextInt(120) + 8);
            double d2 = z * 16 + this.rand.nextInt(16);
            int k = 1;
            if (this.rand.nextInt(4) == 0) {
                this.generateLargeCaveNode(this.rand.nextLong(), chunkX, chunkZ, primer, d, d1, d2);
                k += this.rand.nextInt(4);
            }
            for (int l = 0; l < k; ++l) {
                float f = this.rand.nextFloat() * (float)Math.PI * 2.0f;
                float f1 = (this.rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float f2 = this.rand.nextFloat() * 2.0f + this.rand.nextFloat();
                if (this.rand.nextInt(10) == 0) {
                    f2 *= this.rand.nextFloat() * this.rand.nextFloat() * 3.0f + 1.0f;
                }
                this.generateCaveNode(this.rand.nextLong(), chunkX, chunkZ, primer, d, d1, d2, f2, f, f1, 0, 0, 1.0);
            }
        }
    }
}

