/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.gen.structure;

import com.xcompwiz.mystcraft.block.BlockLectern;
import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.tileentity.TileEntityLectern;
import com.xcompwiz.mystcraft.treasure.LootTableHandler;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;

public class StructureGenerationUtils {
    public static boolean generateLectern(World worldObj, StructureBoundingBox boundingbox, Random rand, BlockPos pos, BlockPos lookPos, LootTable lootTable, LootContext lootContext) {
        if (boundingbox.func_175898_b((Vec3i)pos)) {
            EnumFacing horizontal = EnumFacing.func_176733_a((double)(360 - StructureGenerationUtils.getRotation(pos.func_177958_n(), pos.func_177952_p(), lookPos.func_177958_n(), lookPos.func_177952_p()) + 90));
            worldObj.func_175656_a(pos, ModBlocks.lectern.func_176223_P().func_177226_a(BlockLectern.ROTATION, (Comparable)horizontal));
            TileEntityLectern lectern = (TileEntityLectern)worldObj.func_175625_s(pos);
            if (lectern != null) {
                lectern.setYaw(360 - StructureGenerationUtils.getRotation(pos.func_177958_n(), pos.func_177952_p(), lookPos.func_177958_n(), lookPos.func_177952_p()) + 90);
                ItemStack item = LootTableHandler.generateLecternItem(lectern, rand, lootTable, lootContext);
                if (item != null) {
                    lectern.setBook(item);
                }
            }
            return true;
        }
        return false;
    }

    public static int getRotation(int x1, int y1, int x2, int y2) {
        int deltaX = x2 - x1;
        int deltaZ = -(y2 - y1);
        if (deltaZ == 0) {
            return deltaX < 0 ? 180 : 0;
        }
        if (deltaX == 0) {
            return deltaZ < 0 ? 270 : 90;
        }
        float f = (float)deltaZ / (float)deltaX;
        return (int)(Math.atan(f) * 180.0 / Math.PI);
    }
}

