/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.crafttweaker;

import appeng.integration.abstraction.ICraftTweaker;
import appeng.integration.modules.crafttweaker.AttunementRegistry;
import appeng.integration.modules.crafttweaker.CannonRegistry;
import appeng.integration.modules.crafttweaker.GrinderRecipes;
import appeng.integration.modules.crafttweaker.InscriberRecipes;
import appeng.integration.modules.crafttweaker.SpatialRegistry;
import appeng.util.Platform;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class CTModule
implements ICraftTweaker {
    static final List<IAction> MODIFICATIONS = new ArrayList<IAction>();

    @Override
    public void preInit() {
        CraftTweakerAPI.registerClass(GrinderRecipes.class);
        CraftTweakerAPI.registerClass(InscriberRecipes.class);
        CraftTweakerAPI.registerClass(SpatialRegistry.class);
        CraftTweakerAPI.registerClass(AttunementRegistry.class);
        CraftTweakerAPI.registerClass(CannonRegistry.class);
    }

    @Override
    public void postInit() {
        MODIFICATIONS.forEach(CraftTweakerAPI::apply);
    }

    public static ItemStack toStack(IItemStack iStack) {
        if (iStack == null) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)iStack.getInternal();
    }

    public static List<ItemStack> toStackExpand(IItemStack iStack) {
        if (iStack == null) {
            return Collections.emptyList();
        }
        ItemStack is = (ItemStack)iStack.getInternal();
        if (!is.func_77984_f() && is.func_77952_i() == Short.MAX_VALUE) {
            NonNullList ret = NonNullList.func_191196_a();
            is.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, ret);
            return ret.stream().map(i -> new ItemStack(i.func_77973_b(), iStack.getAmount(), i.func_77952_i())).collect(Collectors.toList());
        }
        return Collections.singletonList(is);
    }

    public static Optional<Collection<ItemStack>> toStacks(IIngredient ingredient) {
        if (ingredient == null) {
            return Optional.empty();
        }
        TreeSet ret = new TreeSet(CTModule::compareItemStacks);
        ingredient.getItems().stream().map(CTModule::toStackExpand).forEach(ret::addAll);
        if (ret.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ret);
    }

    private static int compareItemStacks(ItemStack a, ItemStack b) {
        if (Platform.itemComparisons().isSameItem(a, b)) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return System.identityHashCode(a) - System.identityHashCode(b);
    }
}

