/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui;

import java.io.IOException;
import java.util.ArrayList;
import logisticspipes.items.ItemGuideBook;
import logisticspipes.utils.GuideBookContents;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class GuiGuideBook
extends GuiScreen {
    private static final ResourceLocation GUI_BOOK_TEXTURE = new ResourceLocation("logisticspipes", "textures/gui/guide_book.png");
    private GuiButton nextPageBtn;
    private GuiButton prevPageBtn;
    private GuiButton slider;
    private EnumHand hand;
    private int dragSrcY;
    private float sliderProgress;
    private int sliderTopY;
    private int sliderBotY;
    private GuideBookContents.Page page;
    private int maxLength;
    private int textX;
    private int textY;
    private int maxLines;
    private final float textureSizeX = 256.0f;
    private final float textureSizeY = 256.0f;
    private final int tileSize = 32;
    private final int borderSize = 16;
    private int acrossX;
    private int acrossY;
    private int leftX;
    private int topY;
    private final GuideBookContents gbc;
    private boolean needsInit = true;

    public GuiGuideBook(EnumHand hand, GuideBookContents gbc) {
        this.hand = hand;
        this.gbc = gbc;
        this.page = gbc.getPage(0);
    }

    public void func_73866_w_() {
        int sliderWidth = 20;
        int sliderHeight = 20;
        int guiWidthX = (int)((double)this.field_146294_l * 0.75);
        int guiWidthY = (int)((double)this.field_146295_m * 0.75);
        this.acrossX = guiWidthX - 64;
        this.acrossY = guiWidthY - 64;
        this.leftX = this.field_146294_l / 2 - guiWidthX / 2;
        this.topY = this.field_146295_m / 2 - guiWidthY / 2;
        int rightX = this.field_146294_l / 2 + guiWidthX / 2;
        int bottomX = this.field_146295_m / 2 + guiWidthY / 2;
        this.sliderTopY = this.topY + 16;
        this.sliderBotY = bottomX - 16 - 20;
        int textInset = 24;
        this.textX = this.leftX + textInset;
        this.textY = this.topY + textInset;
        this.maxLength = guiWidthX - 20 - textInset * 2;
        this.maxLines = (this.acrossY + 16) / 10;
        this.field_146292_n.clear();
        this.nextPageBtn = this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 + 100, this.field_146295_m - 30, 20, 20, ">"));
        this.prevPageBtn = this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 - 120, this.field_146295_m - 30, 20, 20, "<"));
        this.slider = this.func_189646_b(new GuiButton(2, rightX - 16 - 20, 0, 20, 20, "|||"));
        this.updateSliderPosition();
        if (this.needsInit) {
            ItemStack book = this.hand == EnumHand.MAIN_HAND ? this.field_146297_k.field_71439_g.func_184614_ca() : this.field_146297_k.field_71439_g.func_184592_cb();
            if (book.func_77942_o()) {
                NBTTagCompound nbtTagCompound = book.func_77978_p();
                GuideBookContents.Page p = this.gbc.getPage(nbtTagCompound.func_74762_e("page"));
                if (p != null) {
                    this.page = p;
                }
                this.sliderProgress = nbtTagCompound.func_74760_g("sliderProgress");
            } else {
                this.setPage(0);
            }
            this.needsInit = false;
        }
        this.updateButtonStates();
    }

    private void drawPageContents() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ArrayList<String> text = GuiGuideBook.splitLines(this.page.getText(), this.field_146289_q, this.maxLength);
        if (text.size() <= this.maxLines) {
            this.slider.field_146124_l = false;
            this.sliderProgress = 0.0f;
            this.updateSliderPosition();
        } else {
            this.slider.field_146124_l = true;
        }
        float translateY = this.sliderProgress * 10.0f * (float)(text.size() - this.maxLines);
        for (int i = 0; i < text.size(); ++i) {
            int drawY = this.textY + 10 * i - (int)translateY;
            if (drawY <= this.textY - 20 || drawY >= this.field_146295_m * 7 / 8 - 10) continue;
            this.func_73731_b(this.field_146289_q, (String)text.get(i), this.textX, drawY, 0xFFFFFF);
        }
    }

    private void drawPageBorder() {
        int rightX = this.leftX + 32 + this.acrossX;
        int bottomY = this.topY + 32 + this.acrossY;
        GlStateManager.func_179147_l();
        this.field_146297_k.field_71446_o.func_110577_a(GUI_BOOK_TEXTURE);
        GuiGuideBook.func_152125_a((int)this.leftX, (int)this.topY, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32, (float)256.0f, (float)256.0f);
        GuiGuideBook.func_152125_a((int)rightX, (int)this.topY, (float)32.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32, (float)256.0f, (float)256.0f);
        GuiGuideBook.func_152125_a((int)this.leftX, (int)bottomY, (float)0.0f, (float)32.0f, (int)32, (int)32, (int)32, (int)32, (float)256.0f, (float)256.0f);
        GuiGuideBook.func_152125_a((int)rightX, (int)bottomY, (float)32.0f, (float)32.0f, (int)32, (int)32, (int)32, (int)32, (float)256.0f, (float)256.0f);
        GuiGuideBook.func_152125_a((int)(this.leftX + 32), (int)this.topY, (float)24.0f, (float)0.0f, (int)8, (int)32, (int)this.acrossX, (int)32, (float)256.0f, (float)256.0f);
        GuiGuideBook.func_152125_a((int)(this.leftX + 32), (int)bottomY, (float)24.0f, (float)32.0f, (int)8, (int)32, (int)this.acrossX, (int)32, (float)256.0f, (float)256.0f);
        GuiGuideBook.func_152125_a((int)this.leftX, (int)(this.topY + 32), (float)0.0f, (float)24.0f, (int)32, (int)8, (int)32, (int)this.acrossY, (float)256.0f, (float)256.0f);
        GuiGuideBook.func_152125_a((int)rightX, (int)(this.topY + 32), (float)32.0f, (float)24.0f, (int)32, (int)8, (int)32, (int)this.acrossY, (float)256.0f, (float)256.0f);
    }

    private void drawPageBackground() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        this.field_146297_k.field_71446_o.func_110577_a(GUI_BOOK_TEXTURE);
        GuiGuideBook.func_152125_a((int)(this.leftX + 16), (int)(this.topY + 16), (float)64.0f, (float)0.0f, (int)16, (int)16, (int)(this.acrossX + 32), (int)(this.acrossY + 32), (float)256.0f, (float)256.0f);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawPageBackground();
        this.drawPageContents();
        this.drawPageBorder();
        this.func_73732_a(this.field_146289_q, this.gbc.getTitle(), this.field_146294_l / 2, this.field_146295_m / 8 + 4, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, String.format("Page %d out of %d", this.page.getIndex() + 1, this.gbc.getPages()), this.field_146294_l / 2, this.field_146295_m - 25, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                if (this.page.getIndex() + 1 >= this.gbc.getPages()) break;
                this.setPage(this.page.getIndex() + 1);
                break;
            }
            case 1: {
                if (this.page.getIndex() - 1 < 0) break;
                this.setPage(this.page.getIndex() - 1);
            }
        }
    }

    private void updateButtonStates() {
        this.nextPageBtn.field_146124_l = this.page.getIndex() < this.gbc.getPages() - 1;
        this.prevPageBtn.field_146124_l = this.page.getIndex() > 0;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.dragSrcY = mouseY;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.slider.field_146124_l) {
            int dy = mouseY - this.dragSrcY;
            this.slider.field_146129_i = MathHelper.func_76125_a((int)(this.slider.field_146129_i + dy), (int)this.sliderTopY, (int)this.sliderBotY);
            this.sliderProgress = ((float)this.slider.field_146129_i - (float)this.sliderTopY) / (float)(this.sliderBotY - this.sliderTopY);
            this.dragSrcY = mouseY;
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    private void setPage(int index) {
        this.page = this.gbc.getPage(index);
        this.setSliderProgress(0.0f);
        this.updateButtonStates();
    }

    private void setSliderProgress(float p) {
        this.sliderProgress = p;
        this.updateSliderPosition();
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
    }

    public void func_146281_b() {
        ItemGuideBook.setCurrentPage(this.page.getIndex(), this.sliderProgress, this.hand);
        super.func_146281_b();
    }

    private void updateSliderPosition() {
        this.slider.field_146129_i = (int)((float)this.sliderTopY + (float)(this.sliderBotY - this.sliderTopY) * this.sliderProgress);
    }

    private static ArrayList<String> splitLines(String text, FontRenderer fontRenderer, int maxLength) {
        if (text.charAt(text.length() - 1) != '\n') {
            text = text + '\n';
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        int lastSplitPoint = 0;
        int curLength = 0;
        for (char c : text.toCharArray()) {
            if (c == '\n') {
                lines.add(currentLine.toString());
                currentLine.delete(0, currentLine.length());
                lastSplitPoint = 0;
                curLength = fontRenderer.func_78256_a(currentLine.toString());
                continue;
            }
            if (Character.isWhitespace(c)) {
                currentLine.append(c);
                curLength += fontRenderer.func_78263_a(c);
                lastSplitPoint = currentLine.length();
                continue;
            }
            if (currentLine.length() > 1 && curLength + fontRenderer.func_78263_a(c) > maxLength) {
                if (lastSplitPoint == 0) {
                    lastSplitPoint = currentLine.length();
                }
                lines.add(currentLine.substring(0, lastSplitPoint));
                currentLine.delete(0, lastSplitPoint);
                lastSplitPoint = 0;
                curLength = fontRenderer.func_78256_a(currentLine.toString());
            }
            currentLine.append(c);
            curLength += fontRenderer.func_78263_a(c);
        }
        return lines;
    }
}

