/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logisticspipes;

import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import net.minecraft.util.EnumFacing;

public class RouteLayer {
    protected final IRouter _router;
    private final TransportLayer _transport;
    private final CoreRoutedPipe _pipe;

    public RouteLayer(IRouter router, TransportLayer transportLayer, CoreRoutedPipe pipe) {
        this._router = router;
        this._transport = transportLayer;
        this._pipe = pipe;
    }

    public EnumFacing getOrientationForItem(IRoutedItem item, EnumFacing blocked) {
        item.checkIDFromUUID();
        if (item.getDestination() < 0) {
            item = SimpleServiceLocator.logisticsManager.assignDestinationFor(item, this._router.getSimpleID(), false);
            this._pipe.debug.log("No Destination, assigned new destination: (" + item.getInfo());
        }
        if (item.getDestination() >= 0 && (!this._router.hasRoute(item.getDestination(), item.getTransportMode() == IRoutedItem.TransportMode.Active, item.getItemIdentifierStack().getItem()) || item.getArrived())) {
            item = SimpleServiceLocator.logisticsManager.assignDestinationFor(item, this._router.getSimpleID(), false);
            this._pipe.debug.log("Unreachable Destination, sssigned new destination: (" + item.getInfo());
        }
        item.checkIDFromUUID();
        if (item.getDestination() < 0) {
            return null;
        }
        if (item.getDestinationUUID().equals(this._router.getId())) {
            this._transport.handleItem(item);
            if (item.getDistanceTracker() != null) {
                item.getDistanceTracker().setCurrentDistanceToTarget(0);
                item.getDistanceTracker().setDestinationReached();
            }
            if (item.getTransportMode() != IRoutedItem.TransportMode.Active && !this._transport.stillWantItem(item)) {
                return this.getOrientationForItem(SimpleServiceLocator.logisticsManager.assignDestinationFor(item, this._router.getSimpleID(), true), null);
            }
            item.setDoNotBuffer(true);
            item.setArrived(true);
            return this._transport.itemArrived(item, blocked);
        }
        if (!this._router.hasRoute(item.getDestination(), item.getTransportMode() == IRoutedItem.TransportMode.Active, item.getItemIdentifierStack().getItem())) {
            return null;
        }
        ExitRoute exit = this._router.getExitFor(item.getDestination(), item.getTransportMode() == IRoutedItem.TransportMode.Active, item.getItemIdentifierStack().getItem());
        if (exit == null) {
            return null;
        }
        if (item.getDistanceTracker() != null) {
            item.getDistanceTracker().setCurrentDistanceToTarget(exit.blockDistance);
        }
        return exit.exitOrientation;
    }
}

