/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import logisticspipes.LPConstants;
import logisticspipes.LogisticsPipes;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.exception.TargetNotFoundException;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.Level;

public class PacketInboundHandler
extends SimpleChannelInboundHandler<PacketHandler.InboundModernPacketWrapper> {
    protected void channelRead0(ChannelHandlerContext ctx, PacketHandler.InboundModernPacketWrapper msg) {
        IThreadListener thread = FMLCommonHandler.instance().getWorldThread((INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get());
        if (thread.func_152345_ab()) {
            this.inThreadProcessPacket(msg.packet, msg.player);
        } else {
            thread.func_152344_a(() -> this.inThreadProcessPacket(msg.packet, msg.player));
        }
    }

    private void inThreadProcessPacket(ModernPacket packet, EntityPlayer player) {
        block4: {
            try {
                packet.processPacket(player);
                if (LPConstants.DEBUG) {
                    PacketHandler.debugMap.remove(packet.getDebugId());
                }
            }
            catch (TargetNotFoundException e) {
                if (packet.retry() && MainProxy.isClient((IBlockAccess)player.func_130014_f_())) {
                    SimpleServiceLocator.clientBufferHandler.queuePacket(packet, player);
                }
                if (!LPConstants.DEBUG) break block4;
                LogisticsPipes.log.error(packet.getClass().getName());
                LogisticsPipes.log.error(packet.toString());
                e.printStackTrace();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log((Level)Level.ERROR, (Throwable)cause, (String)"PacketInboundHandler exception", (Object[])new Object[0]);
        super.exceptionCaught(ctx, cause);
    }
}

