/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import java.util.function.Function;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.exception.TargetNotFoundException;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public abstract class CoordinatesPacket
extends ModernPacket {
    private int posX;
    private int posY;
    private int posZ;

    public CoordinatesPacket(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeInt(this.posX);
        output.writeInt(this.posY);
        output.writeInt(this.posZ);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.posX = input.readInt();
        this.posY = input.readInt();
        this.posZ = input.readInt();
    }

    public CoordinatesPacket setTilePos(TileEntity tile) {
        this.setDimension(tile.func_145831_w());
        this.setPosX(tile.func_174877_v().func_177958_n());
        this.setPosY(tile.func_174877_v().func_177956_o());
        this.setPosZ(tile.func_174877_v().func_177952_p());
        return this;
    }

    public CoordinatesPacket setLPPos(DoubleCoordinates pos) {
        this.setPosX(pos.getXInt());
        this.setPosY(pos.getYInt());
        this.setPosZ(pos.getZInt());
        return this;
    }

    public CoordinatesPacket setPacketPos(CoordinatesPacket packet) {
        this.posX = packet.posX;
        this.posY = packet.posY;
        this.posZ = packet.posZ;
        return this;
    }

    public CoordinatesPacket setBlockPos(BlockPos pos) {
        this.posX = pos.func_177958_n();
        this.posY = pos.func_177956_o();
        this.posZ = pos.func_177952_p();
        return this;
    }

    public TileEntity getTile(World world, Function<TileEntity, Boolean> validateResult) {
        TileEntity tile = this.getTile(world, TileEntity.class);
        if (!validateResult.apply(tile).booleanValue()) {
            this.targetNotFound("TileEntity condition not met");
            return null;
        }
        return tile;
    }

    public <T> T getTile(World world, Class<T> clazz) {
        if (world == null) {
            this.targetNotFound("World was null");
            return null;
        }
        if (world.func_175623_d(new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()))) {
            this.targetNotFound("Couldn't find " + clazz.getName() + " at: " + new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()));
            return null;
        }
        TileEntity tile = world.func_175625_s(new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()));
        if (tile != null) {
            if (!clazz.isAssignableFrom(tile.getClass())) {
                this.targetNotFound("Couldn't find " + clazz.getName() + ", found " + tile.getClass() + " at: " + new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()));
                return null;
            }
        } else {
            this.targetNotFound("Couldn't find " + clazz.getName() + " at: " + new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()));
        }
        return (T)tile;
    }

    public <T> T getTileOrPipe(World world, Class<T> clazz) {
        if (world == null) {
            this.targetNotFound("World was null");
            return null;
        }
        if (world.func_175623_d(new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()))) {
            this.targetNotFound("Couldn't find " + clazz.getName() + " at: " + new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()));
            return null;
        }
        TileEntity tile = world.func_175625_s(new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()));
        if (tile != null) {
            if (clazz.isAssignableFrom(tile.getClass())) {
                return (T)tile;
            }
            if (tile instanceof LogisticsTileGenericPipe) {
                if (((LogisticsTileGenericPipe)tile).pipe != null && clazz.isAssignableFrom(((LogisticsTileGenericPipe)tile).pipe.getClass())) {
                    return (T)((LogisticsTileGenericPipe)tile).pipe;
                }
                this.targetNotFound("Couldn't find " + clazz.getName() + ", found pipe with " + tile.getClass() + " at: " + new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()));
                return null;
            }
        } else {
            this.targetNotFound("Couldn't find " + clazz.getName() + " at: " + new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()));
            return null;
        }
        this.targetNotFound("Couldn't find " + clazz.getName() + ", found " + tile.getClass() + " at: " + new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ()));
        return null;
    }

    @Deprecated
    public LogisticsTileGenericPipe getPipe(World world) {
        return this.getPipe(world, LTGPCompletionCheck.NONE);
    }

    public LogisticsTileGenericPipe getPipe(World world, LTGPCompletionCheck check) {
        LogisticsTileGenericPipe pipe = this.getTile(world, LogisticsTileGenericPipe.class);
        if ((check == LTGPCompletionCheck.PIPE || check == LTGPCompletionCheck.TRANSPORT) && pipe.pipe == null) {
            this.targetNotFound("The found pipe didn't have a loaded pipe field");
        }
        if (check == LTGPCompletionCheck.TRANSPORT && pipe.pipe.transport == null) {
            this.targetNotFound("The found pipe didn't have a loaded transport field");
        }
        return pipe;
    }

    protected void targetNotFound(String message) {
        throw new TargetNotFoundException(message, this);
    }

    public String toString() {
        return "CoordinatesPacket(posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", posZ=" + this.getPosZ() + ")";
    }

    public int getPosX() {
        return this.posX;
    }

    public CoordinatesPacket setPosX(int posX) {
        this.posX = posX;
        return this;
    }

    public int getPosY() {
        return this.posY;
    }

    public CoordinatesPacket setPosY(int posY) {
        this.posY = posY;
        return this;
    }

    public int getPosZ() {
        return this.posZ;
    }

    public CoordinatesPacket setPosZ(int posZ) {
        this.posZ = posZ;
        return this;
    }

    public static enum LTGPCompletionCheck {
        NONE,
        PIPE,
        TRANSPORT;

    }
}

