/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import java.util.List;
import java.util.Set;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public abstract class InventoryModuleCoordinatesPacket
extends ModuleCoordinatesPacket {
    private static final byte STACK_MARKER = 0;
    private static final byte IDENT_MARKER = 1;
    private IInventory inventory;
    private List<ItemStack> stackList;
    private List<ItemIdentifierStack> identList;
    private Set<ItemIdentifierStack> identSet;

    public InventoryModuleCoordinatesPacket(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        if (this.inventory != null) {
            output.writeByte((byte)0);
            output.writeInt(this.inventory.func_70302_i_());
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                output.writeItemStack(this.inventory.func_70301_a(i));
            }
        } else if (this.stackList != null) {
            output.writeByte((byte)0);
            output.writeCollection(this.stackList, LPDataOutput::writeItemStack);
        } else if (this.identList != null) {
            output.writeByte((byte)1);
            output.writeCollection(this.identList, LPDataOutput::writeItemIdentifierStack);
        } else if (this.identSet != null) {
            output.writeByte((byte)1);
            output.writeCollection(this.identSet, LPDataOutput::writeItemIdentifierStack);
        } else {
            throw new IllegalStateException("Wont send packet without content");
        }
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        byte marker = input.readByte();
        if (marker == 0) {
            this.stackList = input.readLinkedList(LPDataInput::readItemStack);
        } else if (marker == 1) {
            this.identList = input.readLinkedList(LPDataInput::readItemIdentifierStack);
        } else {
            throw new UnsupportedOperationException("Unknown marker: " + marker);
        }
    }

    public InventoryModuleCoordinatesPacket setInventory(IInventory inventory) {
        this.inventory = inventory;
        return this;
    }

    public List<ItemStack> getStackList() {
        return this.stackList;
    }

    public InventoryModuleCoordinatesPacket setStackList(List<ItemStack> stackList) {
        this.stackList = stackList;
        return this;
    }

    public List<ItemIdentifierStack> getIdentList() {
        return this.identList;
    }

    public InventoryModuleCoordinatesPacket setIdentList(List<ItemIdentifierStack> identList) {
        this.identList = identList;
        return this;
    }

    public InventoryModuleCoordinatesPacket setIdentSet(Set<ItemIdentifierStack> identSet) {
        this.identSet = identSet;
        return this;
    }
}

