/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class BufferTransfer
extends ModernPacket {
    private byte[] content;

    public BufferTransfer(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new BufferTransfer(this.getId());
    }

    @Override
    public void processPacket(EntityPlayer player) {
        if (MainProxy.isClient((IBlockAccess)player.field_70170_p)) {
            SimpleServiceLocator.clientBufferHandler.handlePacket(this.content);
        } else {
            SimpleServiceLocator.serverBufferHandler.handlePacket(this.content, player);
        }
    }

    @Override
    public void readData(LPDataInput input) {
        this.content = input.readByteArray();
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeByteArray(this.content);
    }

    public byte[] getContent() {
        return this.content;
    }

    public BufferTransfer setContent(byte[] content) {
        this.content = content;
        return this;
    }
}

